/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.safeguard;

import me.valkeea.fishyaddons.config.ItemConfig;
import me.valkeea.fishyaddons.util.PlaySound;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class SlotProtectionManager {
    private SlotProtectionManager() {
    }

    public static boolean isSlotLocked(int slot) {
        return ItemConfig.isSlotLocked(slot);
    }

    public static boolean isSlotBound(int slot) {
        return ItemConfig.getBoundSlot(slot) != -1;
    }

    public static int getBoundSlot(int slot) {
        return ItemConfig.getBoundSlot(slot);
    }

    public static void lockSlot(int slot) {
        if (!SlotProtectionManager.isSlotLocked(slot)) {
            ItemConfig.toggleSlotLock(slot);
            PlaySound.playBindOrLock();
        }
    }

    public static void unlockSlot(int slot) {
        if (SlotProtectionManager.isSlotLocked(slot)) {
            ItemConfig.toggleSlotLock(slot);
            PlaySound.playUnbindOrUnlock();
        }
    }

    public static void bindSlots(int slotA, int slotB) {
        if (!SlotProtectionManager.isSlotBound(slotA) && !SlotProtectionManager.isSlotBound(slotB)) {
            ItemConfig.bindSlots(slotA, slotB);
            PlaySound.playBindOrLock();
        }
    }

    public static void unbindSlots(int slotA, int slotB) {
        if (SlotProtectionManager.isSlotBound(slotA) && SlotProtectionManager.isSlotBound(slotB) && SlotProtectionManager.getBoundSlot(slotA) == slotB) {
            ItemConfig.unbindSlots(slotA, slotB);
            PlaySound.playUnbindOrUnlock();
        }
    }

    public static int remap(class_465<?> screen, int slotId) {
        String guiClass = screen.getClass().getSimpleName();
        if (guiClass.equals("class_490") && slotId >= 5 && slotId <= 43) {
            return slotId;
        }
        if (guiClass.equals("class_476")) {
            int s = slotId - 45;
            if (s >= 9 && s <= 43) {
                return s;
            }
            return -1;
        }
        return -1;
    }

    public static int indexToSlotId(class_465<?> screen, int playerInvIndex) {
        String guiClass = screen.getClass().getSimpleName();
        if (!guiClass.equals("class_475")) {
            return -1;
        }
        return playerInvIndex + 45;
    }
}

