/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.tool;

import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.VCVisuals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FishyMode {
    private static String cachedTheme = null;
    private static int cachedColor = -1914135;

    private FishyMode() {
    }

    public static void init() {
        cachedTheme = FishyConfig.getString("themeMode", "default");
        cachedColor = FishyMode.getThemeColor(cachedTheme);
        VCVisuals.set(cachedColor);
    }

    private static int getThemeColor(String theme) {
        return switch (theme.toLowerCase()) {
            case "purple" -> -3762972;
            case "blue" -> -6108929;
            case "white" -> -1710593;
            case "green" -> -6094942;
            default -> -1914135;
        };
    }

    public static int getCmdColor() {
        String theme = cachedTheme;
        return switch (theme.toLowerCase()) {
            case "purple" -> -8974600;
            case "blue" -> -6108929;
            case "white" -> -1707265;
            case "green" -> -6094942;
            default -> -15401022;
        };
    }

    public static int getThemeColor() {
        return cachedColor;
    }

    public static String getTheme() {
        return cachedTheme;
    }

    public static void setTheme(String mode) {
        FishyConfig.setString("themeMode", mode);
        int color = FishyMode.getThemeColor(mode);
        FishyMode.setColor(color);
        VCVisuals.set(color);
        cachedTheme = mode;
    }

    public static void setColor(int color) {
        cachedColor = color;
    }
}

