/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.tracker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.cache.ApiCache;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ChatDropParser {
    private static final String SHARD_KEYWORD = "shard";
    private static final String SHARD_PLURAL = " shards";
    private static final String COINS_KEYWORD = "coins";
    private static final String COIN_KEYWORD = "coin";
    private static final String CHARM_KEYWORD = "charm";
    private static final String NAGA_KEYWORD = "naga";
    private static final String YOU_CAUGHT = "you caught";
    private static final String RARE_DROP = "rare drop";
    private static final String VERY_RARE_DROP = "very rare drop";
    private static final String CRAZY_RARE_DROP = "crazy rare drop";
    private static final String EXTREMELY_RARE_DROP = "extremely rare drop";
    private static final String INSANE_DROP = "insane drop";
    private static final String PET_DROP = "pet drop";
    private static final String PRAY_TO_RNGESUS_DROP = "pray to rngesus drop";
    private static final String SALT_YOU_CHARMED = "salt you charmed";
    private static final String LOOT_SHARE = "loot share";
    private static final String ANY_CATCH = "\u26c3\\s+\\w+\\s+catch!\\s+you caught\\s+";
    private static final String CATCH_KEYWORD = "catch!";
    private static final String WOW_DUG_OUT = "wow! you dug out";
    private static final String DROP_REGEX_SUFFIX = "!\\s*([^(\\r\\n]+?)(?:\\s*\\([^)]*\\).*)?$";
    private static final List<DropPattern> DROP_PATTERNS = new ArrayList<DropPattern>();
    private static final Set<String> TRACKED_SHARDS = new HashSet<String>();
    private static final Set<String> VALUABLE_KEYWORDS = new HashSet<String>();

    private static void init() {
        String[] keywords;
        String[] shardNames;
        for (String shard : shardNames = new String[]{"spike", "pandarai", "bullfrog", "beaconmite", "bambloom", "mochibear", "seagull", "bambuleaf", "heron", "sparrow", "crow", "birries", "phanflare", "phanpyre", "carvernshade", "bal", "quartzfang", "troglobyte", "miner zombie", "hideonleaf", "dodo", "condor", "toucan", "falcon", "rana", "kiwi", "boreal owl", "lapis skeleton", "megalith", NAGA_KEYWORD, "tortoise", "wyvern", "tiamat", "chameleon", "leatherback", "sea serpent", "caiman", "komodo dragon", "iguana", "moray eel", "basilisk", "fenlord", "alligator", "leviathan", "gecko", "king cobra", "eel", "crocodile", "python", "lizard king", "toad", "viper", "mossybit", "cuboa", "salamander", "newt", "harpy", "tadgang", "starborn", "molthorn", "galaxy fish", "etherdrake", "jormurg", "sun fish", "hideonbox", "ananke", "moltenfish", "daemon", "shellwise", "prince", "hideonsack", "wither", "inferno koi", "draconic", "joydive", "dreadwing", "lumisquid", "carrot king", "snowfin", "hideonring", "silentdepth", "revenant", "bitbug", "arachne", "abyssal lanternfish", "hideondra", "hideongeon", "piranha", "glacite walker", "hideoncave", "yog", "hideongift", "tempest", "aero", "bolt", "quake", "flash", "apex dragon", "cinderbat", "kraken", "blizzard", "cyro", "cascade", "tide", "mist", "xyz", "shinyfish", "endstone protector", "tenebris", "terra", "sylvan", "bramble", "grove", "thorn", "kada knight", "wither spectre", "obsidian defender", "bezal", "zealot", "voracious spider", "tank zombie", "lapis zombie", "barbarian duke", "skeletor", "burningsoul", "flare", "soul of the alpha", "power dragon", "bruiser", "matcho", "sycophant", "rain slime", "golden ghoul", "zombie soldier", "flaming spider", "lava flame", "loch emperor", "magma slug", "lord jawbus", "water hydra", "fire eel", "sea archer", "night squid", "taurus", "lapis creeper", "ghost", "hellwisp", "mimc", "fungloom", "stalagmight", "thyst", "star sentry", "drowned", "stridersurfer", "ent", "seer", "azure", "chill", "salmon", "goldfin", "coralot", "verdant", "cod", "wartybug", "dragonfly", "firefly", "lunar moth", "ladybug", "cropeetle", "invisibug", "termite", "praying mantis", "pest", "mudworm"}) {
            TRACKED_SHARDS.add(shard.toLowerCase());
        }
        for (String keyword : keywords = new String[]{"enchanted", "rare", "epic", "legendary", "book", "talisman", "[Lvl 1]", COIN_KEYWORD, SHARD_KEYWORD}) {
            VALUABLE_KEYWORDS.add(keyword.toLowerCase());
        }
    }

    private static void initPatterns() {
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("rare drop!\\s*You dug out an? ([^!]+)!", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("(?:rare drop|very rare drop|crazy rare drop|extremely rare drop|insane drop)!\\s*\\((\\d+)x\\s+([^)]+?)\\)(?:\\s*\\([^)]*\\))?.*?$", 2), 1, 2));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("(?:rare drop|very rare drop|crazy rare drop|extremely rare drop|insane drop)!\\s*\\((?!\\d+x\\s)([^)]+?)\\)(?:\\s*\\([^)]*\\))?.*?$", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("rare drop!\\s*([^(\\r\\n]+?)(?:\\s*\\([^)]*\\).*)?$", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("very rare drop!\\s*([^(\\r\\n]+?)(?:\\s*\\([^)]*\\).*)?$", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("crazy rare drop!\\s*([^(\\r\\n]+?)(?:\\s*\\([^)]*\\).*)?$", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("extremely rare drop!\\s*([^(\\r\\n]+?)(?:\\s*\\([^)]*\\).*)?$", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("insane drop!\\s*([^(\\r\\n]+?)(?:\\s*\\([^)]*\\).*)?$", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("pray to rngesus drop!\\s*([^(\\r\\n]+?)(?:\\s*\\([^)]*\\).*)?$", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("pet drop!\\s*([^(\\r\\n]+?)(?:\\s*\\([^)]*\\).*)?$", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("\u26c3\\s+\\w+\\s+catch!\\s+you caught\\s+(.+?)\\s+x(\\d{1,3})!", 2), 2, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("\u26c3\\s+\\w+\\s+catch!\\s+you caught\\s+(?:an?\\s+)?(.+?)!", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("wow! you dug out ([\\d,]+)\\s+coins!", 2), -2, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("you caught x(\\d+)\\s+(.+?)\\s*shards?!", 2), 1, 2));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("you caught an?\\s+(.+?)\\s*shard!", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("(?:salt|charm|naga)\\s+you charmed an?\\s+(.+?)\\s+and captured (\\d+)\\s+shards? from it", 2), 2, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("(?:salt|charm|naga)\\s+you charmed an?\\s+(.+?)\\s+and captured its shard", 2), -1, 1));
        DROP_PATTERNS.add(new DropPattern(Pattern.compile("loot share\\s+you received an?\\s+(.+?)\\s*shard for assisting\\s+\\w+!", 2), -1, 1));
    }

    public static ParseResult parseMessage(String message) {
        if (message == null || message.trim().isEmpty()) {
            return null;
        }
        Object cachedResult = ApiCache.getCachedMessageParse(message);
        if (cachedResult != null) {
            if (ApiCache.isNullParseResult(cachedResult)) {
                return null;
            }
            return (ParseResult)cachedResult;
        }
        String lowerMessage = message.toLowerCase();
        if (ChatDropParser.ignore(lowerMessage)) {
            ApiCache.cacheMessageParse(message, null);
            return null;
        }
        if (!ChatDropParser.isDrop(lowerMessage)) {
            ApiCache.cacheMessageParse(message, null);
            return null;
        }
        String cleanMessage = message.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        for (DropPattern pattern : DROP_PATTERNS) {
            ParseResult result = ChatDropParser.tryPattern(pattern, cleanMessage);
            if (result == null) continue;
            ApiCache.cacheMessageParse(message, result);
            return result;
        }
        ApiCache.cacheMessageParse(message, null);
        return null;
    }

    private static boolean isDrop(String lowerMessage) {
        return lowerMessage.contains(RARE_DROP) || lowerMessage.contains(VERY_RARE_DROP) || lowerMessage.contains(CRAZY_RARE_DROP) || lowerMessage.contains(EXTREMELY_RARE_DROP) || lowerMessage.contains(INSANE_DROP) || lowerMessage.contains(PRAY_TO_RNGESUS_DROP) || lowerMessage.contains(PET_DROP) || lowerMessage.contains(CATCH_KEYWORD) || lowerMessage.contains(WOW_DUG_OUT) || lowerMessage.contains(YOU_CAUGHT) || lowerMessage.contains(CHARM_KEYWORD) || lowerMessage.contains(NAGA_KEYWORD) || lowerMessage.contains(SALT_YOU_CHARMED) || lowerMessage.contains(LOOT_SHARE);
    }

    private static boolean ignore(String lowerMessage) {
        if (lowerMessage.contains(CATCH_KEYWORD) || lowerMessage.contains(SHARD_KEYWORD) || lowerMessage.contains("coins!")) {
            return false;
        }
        return lowerMessage.contains("double hook") || lowerMessage.contains("you've hooked an");
    }

    private static ParseResult tryPattern(DropPattern pattern, String cleanMessage) {
        Matcher matcher = pattern.pattern.matcher(cleanMessage);
        if (!matcher.find()) {
            return null;
        }
        try {
            ParseResult result = ChatDropParser.extractItemAndQuantity(pattern, matcher, cleanMessage);
            if (result != null && (result.isCoinDrop || ChatDropParser.isTrackableItem(result.itemName, cleanMessage))) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static ParseResult extractItemAndQuantity(DropPattern pattern, Matcher matcher, String cleanMessage) {
        boolean isCoinDrop = false;
        try {
            String coinMatch;
            String itemName;
            int quantity;
            if (pattern.quantityGroup == -1) {
                quantity = 1;
                itemName = matcher.group(pattern.itemGroup);
            } else if (pattern.quantityGroup == -2) {
                quantityStr = matcher.group(1).replace(",", "");
                quantity = Integer.parseInt(quantityStr);
                itemName = COINS_KEYWORD;
                isCoinDrop = true;
            } else {
                quantityStr = matcher.group(pattern.quantityGroup).replace(",", "");
                quantity = Integer.parseInt(quantityStr);
                itemName = matcher.group(pattern.itemGroup);
            }
            if (!isCoinDrop && ChatDropParser.isCoinsPattern(itemName) && !(coinMatch = itemName.replaceAll("[^\\d,]", "")).isEmpty()) {
                quantity = Integer.parseInt(coinMatch.replace(",", ""));
                itemName = COINS_KEYWORD;
                isCoinDrop = true;
            }
            itemName = ChatDropParser.handleSpecialMessages(itemName, cleanMessage);
            itemName = ChatDropParser.cleanItemName(itemName);
            if (isCoinDrop) {
                return new ParseResult(COINS_KEYWORD, quantity, true);
            }
            itemName = ChatDropParser.detectAndAddShardSuffix(itemName, cleanMessage);
            itemName = ChatDropParser.ensureShardSuffix(itemName, cleanMessage);
            String displayName = ChatDropParser.toSingular(itemName);
            String magicFind = null;
            if (displayName.toLowerCase().contains("enchanted book")) {
                magicFind = ChatDropParser.extractMagicFind(cleanMessage);
            }
            return new ParseResult(displayName, quantity, false, null, magicFind);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isCoinsPattern(String itemName) {
        return itemName.matches("[\\d,]+\\s+coins?!?") || itemName.matches("\\d[\\d,]*\\s+coins?!?") || itemName.toLowerCase().matches("[\\d,]+\\s+coins?!?");
    }

    private static String detectAndAddShardSuffix(String itemName, String originalMessage) {
        String lowerItem = itemName.toLowerCase().trim();
        String lowerMessage = originalMessage.toLowerCase();
        if (lowerItem.contains(SHARD_KEYWORD)) {
            return itemName;
        }
        if (lowerItem.equals(COINS_KEYWORD) || lowerItem.equals(COIN_KEYWORD) || lowerItem.contains(COIN_KEYWORD)) {
            return itemName;
        }
        if (TRACKED_SHARDS.contains(lowerItem) && (lowerMessage.contains("caught") || lowerMessage.contains("good catch") || lowerMessage.contains("great catch") || lowerMessage.contains("outstanding catch"))) {
            return itemName + " shard";
        }
        return itemName;
    }

    private static String ensureShardSuffix(String itemName, String originalMessage) {
        boolean isShardMessage;
        String lowerMessage = originalMessage.toLowerCase();
        String lowerItem = itemName.toLowerCase();
        boolean bl = isShardMessage = lowerMessage.contains(SHARD_KEYWORD) || lowerMessage.contains(CHARM_KEYWORD) || lowerMessage.contains(NAGA_KEYWORD) || lowerMessage.contains(SALT_YOU_CHARMED) || lowerMessage.contains(LOOT_SHARE);
        if (!(!isShardMessage || lowerItem.endsWith(SHARD_KEYWORD) || lowerItem.equals(COINS_KEYWORD) || lowerItem.equals(COIN_KEYWORD) || lowerItem.contains(COIN_KEYWORD))) {
            return itemName + " shard";
        }
        return itemName;
    }

    private static String handleSpecialMessages(String itemName, String cleanMessage) {
        String lowerMessage = cleanMessage.toLowerCase();
        if (lowerMessage.contains(CHARM_KEYWORD) || lowerMessage.contains("salt") || lowerMessage.contains(NAGA_KEYWORD) && (lowerMessage.contains("captured") || lowerMessage.contains(SHARD_KEYWORD))) {
            return itemName + " shard";
        }
        return itemName;
    }

    private static String toSingular(String itemName) {
        String normalized = itemName.toLowerCase();
        if (normalized.contains(SHARD_KEYWORD) && normalized.endsWith(SHARD_PLURAL)) {
            return itemName.substring(0, itemName.length() - 1);
        }
        return itemName;
    }

    private static String cleanItemName(String itemName) {
        String cachedResult = ApiCache.getCachedNormalization(itemName);
        if (cachedResult != null) {
            return cachedResult;
        }
        String cleaned = itemName.trim().replaceAll("\\s+", " ").replaceAll("[\"'`]", "").replaceAll("\\([^)]*\\)", "").replace("\u272f", "").trim().toLowerCase();
        String normalized = ChatDropParser.normalizePlural(cleaned);
        ApiCache.cacheNormalization(itemName, normalized);
        return normalized;
    }

    private static String normalizePlural(String itemName) {
        if (itemName.endsWith(SHARD_PLURAL)) {
            return itemName.replace(SHARD_PLURAL, " shard");
        }
        itemName = ChatDropParser.normalizeSpecificPlurals(itemName);
        return ChatDropParser.normalizeKnownShardPlurals(itemName);
    }

    private static String normalizeSpecificPlurals(String itemName) {
        if (itemName.endsWith(COINS_KEYWORD)) {
            return itemName.replace(COINS_KEYWORD, COIN_KEYWORD);
        }
        return itemName;
    }

    private static String normalizeKnownShardPlurals(String itemName) {
        for (String shard : TRACKED_SHARDS) {
            if (!itemName.equals(shard + "s")) continue;
            return shard;
        }
        return itemName;
    }

    private static boolean isTrackableItem(String itemName, String cleanMessage) {
        String normalized = itemName.toLowerCase();
        String lowerMessage = cleanMessage.toLowerCase();
        if (ChatDropParser.isPlainCoin(normalized)) {
            return false;
        }
        if (TRACKED_SHARDS.contains(normalized) || normalized.contains(COINS_KEYWORD)) {
            return true;
        }
        if (ChatDropParser.isShardItem(normalized)) {
            return true;
        }
        if (ChatDropParser.isRareDropPattern(lowerMessage)) {
            return true;
        }
        return ChatDropParser.hasValuableKeyword(normalized);
    }

    private static boolean isRareDropPattern(String lowerMessage) {
        return lowerMessage.contains(RARE_DROP) || lowerMessage.contains(VERY_RARE_DROP) || lowerMessage.contains(CRAZY_RARE_DROP) || lowerMessage.contains(EXTREMELY_RARE_DROP) || lowerMessage.contains(INSANE_DROP) || lowerMessage.contains(PRAY_TO_RNGESUS_DROP) || lowerMessage.contains("rare catch") || lowerMessage.contains("good catch") || lowerMessage.contains("great catch") || lowerMessage.contains("outstanding catch") || lowerMessage.contains(PET_DROP) || lowerMessage.contains(WOW_DUG_OUT);
    }

    private static boolean isPlainCoin(String normalized) {
        return normalized.equals(COINS_KEYWORD) || normalized.equals(COIN_KEYWORD);
    }

    private static boolean isShardItem(String normalized) {
        if (!normalized.contains(SHARD_KEYWORD)) {
            return false;
        }
        if (normalized.contains("raw salmon") || normalized.contains("shard of the shredded") || normalized.contains("prismarine shard") || normalized.contains("earth shard")) {
            return false;
        }
        for (String shard : TRACKED_SHARDS) {
            if (!normalized.contains(shard)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasValuableKeyword(String normalized) {
        for (String keyword : VALUABLE_KEYWORDS) {
            if (!normalized.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private static String extractMagicFind(String message) {
        if (message == null) {
            return null;
        }
        Pattern magicFindPattern = Pattern.compile("\\(\\+(\\d+) \u272f Magic Find\\)");
        Matcher matcher = magicFindPattern.matcher(message);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private ChatDropParser() {
        throw new UnsupportedOperationException("Utility class");
    }

    static {
        ChatDropParser.init();
        ChatDropParser.initPatterns();
    }

    @Environment(value=EnvType.CLIENT)
    private static class DropPattern {
        final Pattern pattern;
        final int quantityGroup;
        final int itemGroup;

        DropPattern(Pattern pattern, int quantityGroup, int itemGroup) {
            this.pattern = pattern;
            this.quantityGroup = quantityGroup;
            this.itemGroup = itemGroup;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ParseResult {
        public final String itemName;
        public final int quantity;
        public final boolean isCoinDrop;
        public final String tooltipContent;
        public final String magicFind;

        public ParseResult(String itemName, int quantity) {
            this(itemName, quantity, false, null, null);
        }

        public ParseResult(String itemName, int quantity, boolean isCoinDrop) {
            this(itemName, quantity, isCoinDrop, null, null);
        }

        public ParseResult(String itemName, int quantity, boolean isCoinDrop, String tooltipContent) {
            this(itemName, quantity, isCoinDrop, tooltipContent, null);
        }

        public ParseResult(String itemName, int quantity, boolean isCoinDrop, String tooltipContent, String magicFind) {
            this.itemName = itemName;
            this.quantity = quantity;
            this.isCoinDrop = isCoinDrop;
            this.tooltipContent = tooltipContent;
            this.magicFind = magicFind;
        }

        public String toString() {
            if (this.isCoinDrop) {
                return String.format("%s %s", String.format("%,d", this.quantity), this.itemName);
            }
            return String.format("%dx %s", this.quantity, this.itemName);
        }
    }
}

