/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.tracker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import me.valkeea.fishyaddons.tracker.TrackerUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class InventoryTracker {
    private static final int STACK_INCREASE_THRESHOLD = 32;
    private static final Map<Long, EnchantedBookDrop> recentEnchantedBookDrops = new ConcurrentHashMap<Long, EnchantedBookDrop>();
    private static final long DROP_CORRELATION_WINDOW = 5000L;
    private static boolean monitoringEnabled = false;
    private static long monitoringStartTime = 0L;
    private static final long MONITORING_WINDOW = 60000L;
    private static boolean lsEnabled = false;
    private static long lsStartTime = 0L;
    private static final long LS_WINDOW = 10000L;
    private static final Map<String, String> TRACKED_PLAYER_HEADS = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> TRACKED_GHAST_TEARS = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> TRACKED_AXES = new ConcurrentHashMap<String, String>();
    private static final String CLEAN_REGEX = "\u00a7[0-9a-fk-or]";
    private static final Map<Long, String> recentTrackedItemDrops;
    private static final Map<String, Integer> lastKnownStackSizes;

    private InventoryTracker() {
    }

    public static void onEnchantedBookDropDetected(int quantity, String magicFind) {
        long currentTime = System.currentTimeMillis();
        recentEnchantedBookDrops.put(currentTime, new EnchantedBookDrop(quantity, magicFind));
        recentEnchantedBookDrops.entrySet().removeIf(entry -> currentTime - (Long)entry.getKey() > 10000L);
    }

    public static void onItemAdded(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        if (!recentEnchantedBookDrops.isEmpty() && stack.method_7909() == class_1802.field_8598) {
            InventoryTracker.handleEnchantedBookAdded(stack);
            return;
        }
        if (!InventoryTracker.isMonitoringActive()) {
            return;
        }
        if (stack.method_7909() == class_1802.field_8575) {
            InventoryTracker.handlePlayerHeadAdded(stack);
        }
        if (stack.method_7909() == class_1802.field_8070) {
            InventoryTracker.handleGhastTearAdded(stack);
        }
        if (stack.method_7909() == class_1802.field_8475) {
            InventoryTracker.handleAxeAdded(stack);
        }
    }

    private static boolean isMonitoringActive() {
        if (!monitoringEnabled) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - monitoringStartTime > 60000L) {
            monitoringEnabled = false;
            monitoringStartTime = 0L;
            return false;
        }
        return true;
    }

    public static boolean isLsMonitoringActive() {
        if (!lsEnabled) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lsStartTime > 10000L) {
            lsEnabled = false;
            return false;
        }
        return true;
    }

    private static void handleEnchantedBookAdded(class_1799 stack) {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<Long, EnchantedBookDrop> entry : recentEnchantedBookDrops.entrySet()) {
            long dropTime = entry.getKey();
            EnchantedBookDrop drop = entry.getValue();
            if (currentTime - dropTime > 5000L || drop.quantity < stack.method_7947()) continue;
            class_9290 lore = (class_9290)stack.method_58694(class_9334.field_49632);
            String tooltipContent = lore != null ? lore.toString() : null;
            ItemTrackerData.addEnchantedBookDrop("enchanted book", stack.method_7947(), tooltipContent, drop.magicFind);
            recentEnchantedBookDrops.remove(dropTime);
            return;
        }
    }

    private static void handlePlayerHeadAdded(class_1799 stack) {
        int previousStackSize;
        String displayName = stack.method_7964().getString().toLowerCase().trim();
        String cleanDisplayName = displayName.replaceAll(CLEAN_REGEX, "").trim();
        String bazaarId = TRACKED_PLAYER_HEADS.get(cleanDisplayName);
        if (bazaarId == null) {
            return;
        }
        int currentStackSize = stack.method_7947();
        if (currentStackSize > (previousStackSize = lastKnownStackSizes.getOrDefault(cleanDisplayName, 0).intValue())) {
            int rawIncrease = currentStackSize - previousStackSize;
            int newItems = rawIncrease > 32 ? 1 : rawIncrease;
            lastKnownStackSizes.put(cleanDisplayName, currentStackSize);
            TrackerUtils.trackerNoti(cleanDisplayName);
            ItemTrackerData.addDrop(cleanDisplayName, newItems);
        } else {
            lastKnownStackSizes.put(cleanDisplayName, currentStackSize);
        }
    }

    private static void handleGhastTearAdded(class_1799 stack) {
        int previousStackSize;
        String displayName = stack.method_7964().getString().toLowerCase().trim();
        String cleanDisplayName = displayName.replaceAll(CLEAN_REGEX, "").trim();
        String bazaarId = TRACKED_GHAST_TEARS.get(cleanDisplayName);
        if (bazaarId == null) {
            return;
        }
        int currentStackSize = stack.method_7947();
        if (currentStackSize > (previousStackSize = lastKnownStackSizes.getOrDefault(cleanDisplayName, 0).intValue())) {
            int rawIncrease = currentStackSize - previousStackSize;
            int newItems = rawIncrease > 32 ? 1 : rawIncrease;
            lastKnownStackSizes.put(cleanDisplayName, currentStackSize);
            TrackerUtils.trackerNoti(cleanDisplayName);
            ItemTrackerData.addDrop(cleanDisplayName, newItems);
        } else {
            lastKnownStackSizes.put(cleanDisplayName, currentStackSize);
        }
    }

    private static void handleAxeAdded(class_1799 stack) {
        String displayName = stack.method_7964().getString().toLowerCase().trim();
        String cleanDisplayName = displayName.replaceAll(CLEAN_REGEX, "").trim();
        String auctionId = TRACKED_AXES.get(cleanDisplayName);
        if (auctionId == null) {
            return;
        }
        TrackerUtils.trackerNoti(cleanDisplayName);
        ItemTrackerData.addDrop(cleanDisplayName, 1);
    }

    public static void cleanup() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<Long, EnchantedBookDrop> entry2 : recentEnchantedBookDrops.entrySet()) {
            long dropTime = entry2.getKey();
            EnchantedBookDrop drop = entry2.getValue();
            if (currentTime - dropTime <= 5000L) continue;
            ItemTrackerData.addDrop("enchanted book", drop.quantity);
        }
        recentEnchantedBookDrops.entrySet().removeIf(entry -> currentTime - (Long)entry.getKey() > 15000L);
        recentTrackedItemDrops.entrySet().removeIf(entry -> currentTime - (Long)entry.getKey() > 15000L);
        if (lastKnownStackSizes.size() > 63) {
            lastKnownStackSizes.clear();
        }
    }

    public static void onLsDetected() {
        lsEnabled = true;
        lsStartTime = System.currentTimeMillis();
    }

    public static void onValuableEntityDamaged() {
        monitoringEnabled = true;
        monitoringStartTime = System.currentTimeMillis();
    }

    public static void onValuableEntityDeath() {
        monitoringEnabled = true;
        monitoringStartTime = System.currentTimeMillis();
        Thread.startVirtualThread(() -> {
            try {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() - monitoringStartTime >= 1000L) {
                    monitoringEnabled = false;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    static {
        TRACKED_PLAYER_HEADS.put("emperor's skull", "DIVER_FRAGMENT");
        TRACKED_PLAYER_HEADS.put("magma lord fragment", "MAGMA_LORD_FRAGMENT");
        TRACKED_PLAYER_HEADS.put("soul fragment", "SOUL_FRAGMENT");
        TRACKED_PLAYER_HEADS.put("foraging exp boost", "Foraging Exp Boost");
        TRACKED_PLAYER_HEADS.put("minos relic", "Minos Relic");
        TRACKED_PLAYER_HEADS.put("dwarf turtle shelmet", "Dwarf Turtle Shelmet");
        TRACKED_PLAYER_HEADS.put("antique remedies", "Antique Remedies");
        TRACKED_PLAYER_HEADS.put("crown of greed", "Crown of Greed");
        TRACKED_GHAST_TEARS.put("great white shark tooth", "GREAT_WHITE_SHARK_TOOTH");
        recentTrackedItemDrops = new ConcurrentHashMap<Long, String>();
        lastKnownStackSizes = new ConcurrentHashMap<String, Integer>();
    }

    @Environment(value=EnvType.CLIENT)
    private static class EnchantedBookDrop {
        final int quantity;
        final String magicFind;

        EnchantedBookDrop(int quantity, String magicFind) {
            this.quantity = quantity;
            this.magicFind = magicFind;
        }
    }
}

