/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.tracker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.api.HypixelPriceClient;
import me.valkeea.fishyaddons.cache.ApiCache;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.tracker.TrackerUtils;
import me.valkeea.fishyaddons.util.FishyNotis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ItemTrackerData {
    private static final Map<String, Integer> itemCounts = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Double> itemValues = new ConcurrentHashMap<String, Double>();
    private static final String BOOK_DROP_MESSAGE = "BOOK DROP!";
    private static final String ENCHANTED_BOOK = "enchanted book";
    private static final String REGEX = "[^a-zA-Z0-9]";
    private static long sessionStartTime = System.currentTimeMillis();
    private static long lastActivityTime = System.currentTimeMillis();
    private static long totalPausedTime = 0L;
    private static final long INACTIVITY_THRESHOLD = 180000L;
    private static double sessionCoins = 0.0;
    private static HypixelPriceClient priceClient = null;

    public static void init() {
        if (priceClient == null) {
            priceClient = new HypixelPriceClient();
        }
    }

    public static void shutdown() {
        if (priceClient != null) {
            priceClient.shutdown();
            priceClient = null;
        }
    }

    public static void addDrop(String itemName, int quantity) {
        if (itemName == null || itemName.trim().isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long timeSinceLastActivity = currentTime - lastActivityTime;
        if (timeSinceLastActivity > 180000L) {
            totalPausedTime += timeSinceLastActivity;
        }
        lastActivityTime = currentTime;
        String normalizedName = ItemTrackerData.normalizeItemName(itemName);
        itemCounts.merge(normalizedName, quantity, Integer::sum);
        if (priceClient != null && !itemValues.containsKey(normalizedName)) {
            new Thread(() -> {
                try {
                    double price = priceClient.getBestPrice(normalizedName);
                    if (price > 0.0) {
                        itemValues.put(normalizedName, price);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error fetching price for " + normalizedName + ": " + e.getMessage());
                }
            }, "AutoPriceLookup-" + normalizedName.replaceAll(REGEX, "")).start();
        }
    }

    public static boolean isItemTracked(String itemName) {
        if (itemName == null || itemName.trim().isEmpty()) {
            return false;
        }
        String normalizedName = ItemTrackerData.normalizeItemName(itemName);
        return itemCounts.containsKey(normalizedName);
    }

    public static void addCoins(double coinAmount) {
        sessionCoins += coinAmount;
    }

    public static double getSessionCoins() {
        return sessionCoins;
    }

    public static Map<String, Integer> getAllItems() {
        return new HashMap<String, Integer>(itemCounts);
    }

    public static void clearAll() {
        itemCounts.clear();
        itemValues.clear();
        sessionCoins = 0.0;
        sessionStartTime = System.currentTimeMillis();
        lastActivityTime = System.currentTimeMillis();
        totalPausedTime = 0L;
        ApiCache.cleanupExpiredEntries();
    }

    public static long getSessionStartTime() {
        return sessionStartTime;
    }

    public static long getTotalDurationMinutes() {
        long currentTime = System.currentTimeMillis();
        long totalElapsed = currentTime - sessionStartTime;
        long currentPausedTime = totalPausedTime;
        long timeSinceLastActivity = currentTime - lastActivityTime;
        if (timeSinceLastActivity > 180000L) {
            currentPausedTime += timeSinceLastActivity;
        }
        long activeTime = totalElapsed - currentPausedTime;
        return Math.max(0L, activeTime) / 60000L;
    }

    public static boolean isCurrentlyPaused() {
        long timeSinceLastActivity = System.currentTimeMillis() - lastActivityTime;
        return timeSinceLastActivity > 180000L;
    }

    public static long getInactiveMinutes() {
        if (!ItemTrackerData.isCurrentlyPaused()) {
            return 0L;
        }
        long timeSinceLastActivity = System.currentTimeMillis() - lastActivityTime;
        return timeSinceLastActivity / 60000L;
    }

    private static String normalizeItemName(String itemName) {
        return itemName.trim().replaceAll("\u00a7[0-9a-fk-or]", "").replaceAll("\\s+", " ").toLowerCase();
    }

    public static boolean hasData() {
        return !itemCounts.isEmpty();
    }

    public static int getTotalItemCount() {
        return itemCounts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public static int getItemCount(String itemName) {
        return itemCounts.getOrDefault(ItemTrackerData.normalizeItemName(itemName), 0);
    }

    public static double getTotalSessionValue() {
        double totalValue = sessionCoins;
        for (Map.Entry<String, Integer> entry : itemCounts.entrySet()) {
            String itemName = entry.getKey();
            int quantity = entry.getValue();
            double unitPrice = 0.0;
            Double cachedValue = itemValues.get(itemName);
            if (cachedValue != null) {
                unitPrice = cachedValue;
            } else if (priceClient != null) {
                if (priceClient.hasBazaarData(itemName)) {
                    unitPrice = priceClient.getBazaarBuyPrice(itemName);
                    itemValues.put(itemName, unitPrice);
                } else if (priceClient.hasAuctionData(itemName)) {
                    unitPrice = priceClient.getCachedAuctionPrice(itemName);
                    itemValues.put(itemName, unitPrice);
                }
            }
            if (unitPrice == 0.0) {
                unitPrice = ItemTrackerData.getEstimatedValue(itemName);
                itemValues.put(itemName, unitPrice);
            }
            totalValue += unitPrice * (double)quantity;
        }
        return totalValue;
    }

    public static double getCachedItemValue(String itemName) {
        double estimatedValue;
        String normalizedName = ItemTrackerData.normalizeItemName(itemName);
        Double cachedValue = itemValues.get(normalizedName);
        if (cachedValue != null) {
            return cachedValue;
        }
        if (priceClient != null) {
            double price;
            if (priceClient.hasBazaarData(normalizedName)) {
                price = priceClient.getBazaarBuyPrice(normalizedName);
                if (price > 0.0) {
                    itemValues.put(normalizedName, price);
                    return price;
                }
            } else if (priceClient.hasAuctionData(normalizedName) && (price = priceClient.getCachedAuctionPrice(normalizedName)) > 0.0) {
                itemValues.put(normalizedName, price);
                return price;
            }
        }
        if ((estimatedValue = ItemTrackerData.getEstimatedValue(normalizedName)) > 0.0) {
            itemValues.put(normalizedName, estimatedValue);
        }
        return estimatedValue;
    }

    public static double getItemValue(String itemName) {
        double apiValue;
        String normalizedName = ItemTrackerData.normalizeItemName(itemName);
        Double cachedValue = itemValues.get(normalizedName);
        if (cachedValue != null) {
            return cachedValue;
        }
        if (priceClient != null && (apiValue = priceClient.getBestPrice(itemName)) > 0.0) {
            itemValues.put(normalizedName, apiValue);
            return apiValue;
        }
        double estimatedValue = ItemTrackerData.getEstimatedValue(normalizedName);
        itemValues.put(normalizedName, estimatedValue);
        return estimatedValue;
    }

    private static double getEstimatedValue(String itemName) {
        if (itemName.contains("shard")) {
            return 1000.0;
        }
        switch (itemName.toLowerCase()) {
            case "enchanted book": {
                return 5.0;
            }
            case "ender chestplate": 
            case "ender leggings": 
            case "ender boots": 
            case "ender helmet": {
                return 10000.0;
            }
            case "lushlilac": {
                return 15000.0;
            }
        }
        return 2.0;
    }

    public static boolean hasApiPriceData(String itemName) {
        return priceClient != null && priceClient.hasPriceData(itemName);
    }

    public static String getPriceSource(String itemName) {
        if (priceClient != null) {
            HypixelPriceClient.PriceSource source = priceClient.getPriceSource(itemName);
            return source.name();
        }
        return "NONE";
    }

    public static long getLastApiUpdateTime() {
        return priceClient != null ? priceClient.getLastBazaarUpdate() : 0L;
    }

    public static long getLastBazaarUpdateTime() {
        return priceClient != null ? priceClient.getLastBazaarUpdate() : 0L;
    }

    public static long getLastAuctionUpdateTime() {
        return priceClient != null ? priceClient.getLastAuctionUpdate() : 0L;
    }

    public static void refreshPrices() {
        if (priceClient != null) {
            priceClient.refreshAllAsync();
        }
    }

    public static void refreshBazaarPrices() {
        if (priceClient != null) {
            priceClient.refreshBazaarAsync();
        }
    }

    public static HypixelPriceClient getPriceClient() {
        return priceClient;
    }

    public static void getItemValueAsync(String itemName, ItemValueCallback callback) {
        double auctionPrice;
        double bazaarPrice;
        String normalizedName = ItemTrackerData.normalizeItemName(itemName);
        Double cachedValue = itemValues.get(normalizedName);
        if (cachedValue != null) {
            String source = priceClient != null ? priceClient.getPriceSource(itemName).name() : "CACHED";
            callback.onResult(cachedValue, source);
            return;
        }
        if (priceClient != null && priceClient.hasBazaarData(itemName) && (bazaarPrice = priceClient.getBazaarBuyPrice(itemName)) > 0.0) {
            itemValues.put(normalizedName, bazaarPrice);
            callback.onResult(bazaarPrice, "BAZAAR");
            return;
        }
        if (priceClient != null && priceClient.hasAuctionData(itemName) && (auctionPrice = priceClient.getLowestBinPrice(itemName)) > 0.0) {
            itemValues.put(normalizedName, auctionPrice);
            callback.onResult(auctionPrice, "AUCTION");
            return;
        }
        new Thread(() -> {
            try {
                double value = ItemTrackerData.getItemValue(itemName);
                String source = priceClient != null ? priceClient.getPriceSource(itemName).name() : "ESTIMATED";
                callback.onResult(value, source);
            }
            catch (Exception e) {
                double estimatedValue = ItemTrackerData.getEstimatedValue(normalizedName);
                callback.onResult(estimatedValue, "ESTIMATED");
            }
        }, "AsyncValueLookup-" + itemName.replaceAll(REGEX, "")).start();
    }

    public static void updateAllAsync() {
        if (priceClient == null) {
            return;
        }
        HashMap<String, Integer> currentItems = new HashMap<String, Integer>(itemCounts);
        new Thread(() -> {
            for (String normalizedItemName : currentItems.keySet()) {
                try {
                    if (itemValues.containsKey(normalizedItemName)) continue;
                    ItemTrackerData.getItemValue(normalizedItemName);
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    System.err.println("Background price update interrupted");
                    break;
                }
                catch (Exception e) {
                    System.err.println("Error updating price for " + normalizedItemName + ": " + e.getMessage());
                }
            }
        }, "BackgroundPriceUpdate").start();
    }

    public static void forceRefreshAuctionCache() {
        if (priceClient == null) {
            return;
        }
        new Thread(() -> {
            try {
                String itemName;
                priceClient.clearAuctionCache();
                HashMap<String, Integer> items = new HashMap<String, Integer>(itemCounts);
                int refreshCount = 0;
                Iterator iterator = items.keySet().iterator();
                while (iterator.hasNext() && ItemTrackerData.refreshAuctionItem(itemName = (String)iterator.next())) {
                    ++refreshCount;
                }
                FishyNotis.alert((class_2561)class_2561.method_43470((String)("\u00a77Auction cache refresh completed. Updated " + refreshCount + " items.")));
            }
            catch (Exception e) {
                System.err.println("Error during force auction refresh: " + e.getMessage());
            }
        }, "ForceAuctionRefresh").start();
    }

    private static boolean refreshAuctionItem(String itemName) {
        try {
            double price = priceClient.getLowestBinPrice(itemName);
            if (price > 0.0) {
                // empty if block
            }
            Thread.sleep(200L);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception e) {
            System.err.println("Error refreshing " + itemName + ": " + e.getMessage());
            return true;
        }
    }

    public static String enhanceItemName(String rawItemName, String tooltipContent) {
        String enhancedName;
        if (rawItemName == null || rawItemName.trim().isEmpty()) {
            return rawItemName;
        }
        String cleanItemName = ItemTrackerData.normalizeItemName(rawItemName);
        if (cleanItemName.equals(ENCHANTED_BOOK) && tooltipContent != null && (enhancedName = ItemTrackerData.extractEnchantedBookName(tooltipContent)) != null && !enhancedName.trim().isEmpty() && !enhancedName.equals(ENCHANTED_BOOK)) {
            return enhancedName;
        }
        return rawItemName;
    }

    public static void addEnchantedBookDrop(String rawItemName, int quantity, String tooltipContent, String magicFind) {
        String enhancedName = ItemTrackerData.enhanceItemName(rawItemName, tooltipContent);
        if (enhancedName != null && !enhancedName.equals(ENCHANTED_BOOK) && tooltipContent != null) {
            boolean isUltimate = tooltipContent.contains("color=light_purple") || tooltipContent.contains("color=magenta");
            ItemTrackerData.addEnchantedBook(enhancedName, quantity, isUltimate, magicFind);
        } else {
            ItemTrackerData.addDrop(ENCHANTED_BOOK, quantity);
        }
    }

    protected static String extractEnchantedBookName(String tooltipContent) {
        if (tooltipContent == null || tooltipContent.trim().isEmpty()) {
            return null;
        }
        return ItemTrackerData.extractFromMinecraftTextFormat(tooltipContent);
    }

    private static String extractFromMinecraftTextFormat(String tooltipContent) {
        Pattern literalPattern = Pattern.compile("literal\\{([^}]+)\\}\\[style=\\{([^}]*)\\}\\]", 32);
        Matcher literalMatcher = literalPattern.matcher(tooltipContent);
        String firstLiteral = null;
        while (literalMatcher.find()) {
            String name = literalMatcher.group(1);
            String style = literalMatcher.group(2);
            if (firstLiteral == null) {
                firstLiteral = name;
            }
            if (!style.contains("light_purple")) continue;
            return name;
        }
        if (firstLiteral != null) {
            return firstLiteral;
        }
        return null;
    }

    private static void showBookDropAlert(String enchantmentName, String magicFind) {
        if (FishyConfig.getState("bookDropAlert", true)) {
            class_5250 message = class_2561.method_43470((String)BOOK_DROP_MESSAGE).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067});
            message = message.method_10852((class_2561)class_2561.method_43470((String)(" " + enchantmentName)).method_27695(new class_124[]{class_124.field_1068, class_124.field_1070}));
            if (magicFind != null && !magicFind.trim().isEmpty()) {
                message = message.method_10852((class_2561)class_2561.method_43470((String)(" (+" + magicFind + " \u272f Magic Find)")).method_27692(class_124.field_1075));
            }
            message = message.method_10852((class_2561)class_2561.method_43470((String)" \u03b1").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}));
            FishyNotis.alert((class_2561)message);
        }
    }

    public static void addEnchantedBook(String enchantmentName, int quantity, boolean isUltimate) {
        ItemTrackerData.addEnchantedBook(enchantmentName, quantity, isUltimate, null);
    }

    public static void addEnchantedBook(String enchantmentName, int quantity, boolean isUltimate, String magicFind) {
        if (enchantmentName == null || enchantmentName.trim().isEmpty()) {
            return;
        }
        ItemTrackerData.showBookDropAlert(enchantmentName, magicFind);
        if (!TrackerUtils.isEnabled()) {
            return;
        }
        String normalizedName = ItemTrackerData.normalizeItemName(enchantmentName);
        itemCounts.merge(normalizedName, quantity, Integer::sum);
        if (priceClient != null && !itemValues.containsKey(normalizedName)) {
            new Thread(() -> {
                try {
                    double price = priceClient.getEnchantmentPrice(enchantmentName, isUltimate);
                    if (price > 0.0) {
                        itemValues.put(normalizedName, price);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error fetching enchantment price for " + enchantmentName + ": " + e.getMessage());
                }
            }, "EnchantmentPriceLookup-" + normalizedName.replaceAll(REGEX, "")).start();
        }
    }

    public static void removeGenericEnchantedBook(int quantity) {
        String genericName = ItemTrackerData.normalizeItemName(ENCHANTED_BOOK);
        Integer genericCount = itemCounts.get(genericName);
        if (genericCount != null && genericCount >= quantity) {
            if (genericCount == quantity) {
                itemCounts.remove(genericName);
            } else {
                itemCounts.put(genericName, genericCount - quantity);
            }
        }
    }

    public static void clearValueCache() {
        itemValues.clear();
    }

    public static long getLastActivityTime() {
        return lastActivityTime;
    }

    public static long getTotalPausedTime() {
        return totalPausedTime;
    }

    public static void setAllItems(Map<String, Integer> items) {
        itemCounts.clear();
        if (items != null) {
            itemCounts.putAll(items);
        }
    }

    public static void setSessionStartTime(long time) {
        sessionStartTime = time;
    }

    public static void setLastActivityTime(long time) {
        lastActivityTime = time;
    }

    public static void setTotalPausedTime(long time) {
        totalPausedTime = time;
    }

    private ItemTrackerData() {
        throw new UnsupportedOperationException("Utility class");
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ItemValueCallback {
        public void onResult(double var1, String var3);
    }
}

