/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.tracker;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.cache.ApiCache;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.tracker.ChatDropParser;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2568;

@Environment(value=EnvType.CLIENT)
public class SackDropParser {
    private static final String SACK_HOVER_PREFIX = "SACK_HOVER:";
    private static final String SACK_CACHE_PREFIX = "SACK:";
    private static boolean shouldTrackSack = false;
    private static final Map<String, Long> recentlyProcessedTooltips = new ConcurrentHashMap<String, Long>();
    private static final long DEDUP_WINDOW_MS = 1000L;
    private static final Map<String, ChatDropEntry> recentChatDrops = new ConcurrentHashMap<String, ChatDropEntry>();
    private static final Pattern SACK_MESSAGE_PATTERN = Pattern.compile("\\[Sacks\\]\\s*\\+\\d+\\s*items?\\.\\s*\\(Last\\s+\\d+[smh]\\.\\)", 2);
    private static final Pattern HOVER_DROP_PATTERN = Pattern.compile("\\+\\s*(\\d+)\\s+(.+?)(?:\\s*\\([^)]*\\ssack\\))?$", 2);

    private SackDropParser() {
    }

    public static boolean isOn() {
        return shouldTrackSack;
    }

    public static void refresh() {
        shouldTrackSack = FishyConfig.getState("trackSack", false) && FishyConfig.getState("profitTrackerHud", false);
    }

    public static void toggle() {
        FishyConfig.toggle("trackSack", false);
        SackDropParser.refresh();
    }

    public static boolean isSackNotification(String message) {
        if (!shouldTrackSack) {
            return false;
        }
        if (message == null || message.trim().isEmpty()) {
            return false;
        }
        String cleanMessage = message.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        return SACK_MESSAGE_PATTERN.matcher(cleanMessage).find();
    }

    public static List<ChatDropParser.ParseResult> parseSackHoverEvent(class_2568 hoverEvent) {
        List<ChatDropParser.ParseResult> results = new ArrayList<ChatDropParser.ParseResult>();
        if (!shouldTrackSack) {
            return results;
        }
        if (hoverEvent == null || hoverEvent.method_10892() != class_2568.class_5247.field_24342) {
            return results;
        }
        String tooltipContent = SackDropParser.extractTooltipContent(hoverEvent);
        if (tooltipContent == null || tooltipContent.trim().isEmpty()) {
            return results;
        }
        String tooltipHash = String.valueOf(tooltipContent.hashCode());
        long currentTime = System.currentTimeMillis();
        Long lastProcessed = recentlyProcessedTooltips.get(tooltipHash);
        if (lastProcessed != null && currentTime - lastProcessed < 1000L) {
            return results;
        }
        recentlyProcessedTooltips.put(tooltipHash, currentTime);
        SackDropParser.cleanupOldTooltipEntries(currentTime);
        Object cachedResult = ApiCache.getCachedMessageParse(SACK_HOVER_PREFIX + tooltipContent);
        if (cachedResult != null) {
            if (ApiCache.isNullParseResult(cachedResult)) {
                return results;
            }
            List cachedResults = (List)cachedResult;
            return cachedResults;
        }
        results = SackDropParser.parseTooltipContent(tooltipContent);
        if (!results.isEmpty()) {
            SackDropParser.clearChatDrops();
        }
        if (results.isEmpty()) {
            ApiCache.cacheMessageParse(SACK_HOVER_PREFIX + tooltipContent, null);
        } else {
            ApiCache.cacheMessageParse(SACK_HOVER_PREFIX + tooltipContent, results);
        }
        recentlyProcessedTooltips.put(tooltipContent, currentTime);
        return results;
    }

    private static void cleanupOldTooltipEntries(long currentTime) {
        recentlyProcessedTooltips.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 2000L);
    }

    private static String extractTooltipContent(class_2568 hoverEvent) {
        try {
            if (hoverEvent instanceof class_2568.class_10613) {
                class_2568.class_10613 showText = (class_2568.class_10613)hoverEvent;
                class_2561 tooltipText = showText.comp_3510();
                return tooltipText.getString();
            }
        }
        catch (Exception showText) {
            // empty catch block
        }
        try {
            Method getValueMethod = hoverEvent.getClass().getMethod("getValue", class_2568.class_5247.class);
            Object value = getValueMethod.invoke((Object)hoverEvent, hoverEvent.method_10892());
            if (value instanceof class_2561) {
                class_2561 tooltipText = (class_2561)value;
                return tooltipText.getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static List<ChatDropParser.ParseResult> parseTooltipContent(String tooltipContent) {
        String[] lines;
        ArrayList<ChatDropParser.ParseResult> results = new ArrayList<ChatDropParser.ParseResult>();
        for (String line : lines = tooltipContent.split("\\n")) {
            ChatDropParser.ParseResult result;
            String cleanLine = line.trim();
            if (cleanLine.isEmpty() || (result = SackDropParser.parseTooltipLine(cleanLine)) == null) continue;
            results.add(result);
        }
        return results;
    }

    private static ChatDropParser.ParseResult parseTooltipLine(String line) {
        Matcher matcher = HOVER_DROP_PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        try {
            int sackQuantity = Integer.parseInt(matcher.group(1));
            String itemName = matcher.group(2).trim();
            itemName = SackDropParser.cleanSackItemName(itemName);
            if (SackDropParser.isTrackableSackItem(itemName)) {
                int chatQuantity = SackDropParser.getChatDropQuantity(itemName);
                if (chatQuantity > 0) {
                    int remainingQuantity = sackQuantity - chatQuantity;
                    if (remainingQuantity <= 0) {
                        return null;
                    }
                    return new ChatDropParser.ParseResult(itemName, remainingQuantity, false);
                }
                return new ChatDropParser.ParseResult(itemName, sackQuantity, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static String cleanSackItemName(String itemName) {
        if (itemName == null) {
            return "";
        }
        String cachedResult = ApiCache.getCachedNormalization(SACK_CACHE_PREFIX + itemName);
        if (cachedResult != null) {
            return cachedResult;
        }
        String cleaned = itemName.trim().replaceAll("\\s+", " ").replaceAll("[\"'`]", "").replace("\u272f", "").trim().toLowerCase();
        ApiCache.cacheNormalization(SACK_CACHE_PREFIX + itemName, cleaned);
        return cleaned;
    }

    private static boolean isTrackableSackItem(String itemName) {
        return itemName != null && !itemName.trim().isEmpty();
    }

    private static int getChatDropQuantity(String itemName) {
        ChatDropEntry entry = recentChatDrops.get(itemName);
        if (entry != null) {
            return entry.quantity;
        }
        return 0;
    }

    private static void clearChatDrops() {
        recentChatDrops.clear();
    }

    public static void registerChatDrop(String itemName, int quantity) {
        if (!shouldTrackSack) {
            return;
        }
        String normalizedItemName = SackDropParser.cleanSackItemName(itemName);
        recentChatDrops.put(normalizedItemName, new ChatDropEntry(quantity, System.currentTimeMillis()));
    }

    @Environment(value=EnvType.CLIENT)
    private static class ChatDropEntry {
        final int quantity;
        final long timestamp;

        ChatDropEntry(int quantity, long timestamp) {
            this.quantity = quantity;
            this.timestamp = timestamp;
        }
    }
}

