/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.tracker;

import java.util.List;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.TrackerProfiles;
import me.valkeea.fishyaddons.gui.VCOverlay;
import me.valkeea.fishyaddons.gui.VCPopup;
import me.valkeea.fishyaddons.tracker.ChatDropParser;
import me.valkeea.fishyaddons.tracker.InventoryTracker;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import me.valkeea.fishyaddons.tracker.SackDropParser;
import me.valkeea.fishyaddons.util.FishyNotis;
import me.valkeea.fishyaddons.util.HelpUtil;
import me.valkeea.fishyaddons.util.SkyblockCheck;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class TrackerUtils {
    private static boolean pricePerItem = false;
    private static boolean bookEnabled = false;
    private static boolean enabled = false;

    public static boolean isOn() {
        return pricePerItem;
    }

    public static boolean bookEnabled() {
        return bookEnabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void refresh() {
        pricePerItem = FishyConfig.getState("pricePerItem", false);
        bookEnabled = FishyConfig.getState("bookDropAlert", false);
        enabled = FishyConfig.getState("profitTrackerHud", false);
    }

    public static void setPricePerItem(boolean state) {
        pricePerItem = state;
        FishyConfig.toggle("pricePerItem", state);
    }

    public static void handleChat(String message) {
        if (!SkyblockCheck.getInstance().rules()) {
            return;
        }
        String s = HelpUtil.stripColor(message);
        if (s.startsWith("[") || s.startsWith("Guild") || s.startsWith("Party")) {
            return;
        }
        ChatDropParser.ParseResult result = ChatDropParser.parseMessage(message);
        if (!enabled && bookEnabled) {
            if (result != null && !result.isCoinDrop && result.itemName.toLowerCase().contains("enchanted book")) {
                InventoryTracker.onEnchantedBookDropDetected(result.quantity, result.magicFind);
            }
            return;
        }
        if (s.toLowerCase().contains("loot share")) {
            InventoryTracker.onLsDetected();
            return;
        }
        if (result != null) {
            SackDropParser.registerChatDrop(result.itemName, result.quantity);
            if (result.isCoinDrop) {
                ItemTrackerData.addCoins(result.quantity);
            } else if (result.itemName.toLowerCase().contains("enchanted book")) {
                InventoryTracker.onEnchantedBookDropDetected(result.quantity, result.magicFind);
            } else {
                ItemTrackerData.addDrop(result.itemName, result.quantity);
            }
        }
    }

    public static void handleSackDrop(ChatDropParser.ParseResult drop) {
        if (drop != null) {
            ItemTrackerData.addDrop(drop.itemName, drop.quantity);
        }
    }

    public static void checkForHoverEvents(class_2561 message) {
        String fullMessageText;
        if (!SkyblockCheck.getInstance().rules() || !enabled) {
            return;
        }
        boolean sackTrackingEnabled = SackDropParser.isOn();
        if (sackTrackingEnabled && SackDropParser.isSackNotification(fullMessageText = TrackerUtils.reconstruct(message))) {
            TrackerUtils.handleSackNotification(message);
            return;
        }
        for (class_2561 sibling : message.method_10855()) {
            TrackerUtils.checkForHoverEvents(sibling);
        }
    }

    private static String reconstruct(class_2561 message) {
        StringBuilder fullText = new StringBuilder();
        fullText.append(message.getString());
        for (class_2561 sibling : message.method_10855()) {
            fullText.append(TrackerUtils.reconstruct(sibling));
        }
        return fullText.toString();
    }

    private static void handleSackNotification(class_2561 message) {
        if (TrackerUtils.processSackHover(message.method_10866())) {
            return;
        }
        for (class_2561 sibling : message.method_10855()) {
            if (!TrackerUtils.processSackHover(sibling.method_10866())) continue;
            return;
        }
    }

    private static boolean processSackHover(class_2583 style) {
        if (style != null && style.method_10969() != null) {
            List<ChatDropParser.ParseResult> sackDrops = SackDropParser.parseSackHoverEvent(style.method_10969());
            for (ChatDropParser.ParseResult drop : sackDrops) {
                TrackerUtils.handleSackDrop(drop);
            }
            return true;
        }
        return false;
    }

    public static void onDelete(String profile) {
        FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a7cDeleted profile: " + profile)));
        if (profile.equals(TrackerProfiles.getCurrentProfile())) {
            TrackerProfiles.setCurrentProfile("default");
            FishyNotis.notice("Switched to default profile");
        }
    }

    public static void save() {
        if (TrackerProfiles.getCurrentProfile().equals("default")) {
            TrackerUtils.createOrSavePopup(1.0f);
        } else {
            TrackerProfiles.saveToJson();
            FishyNotis.notice("Saved tracker data to file");
        }
    }

    public static void createOrSavePopup(float scale) {
        VCPopup popup = new VCPopup((class_2561)class_2561.method_43470((String)"Profile name:"), () -> class_310.method_1551().method_1507(null), "Cancel", profileName -> {
            TrackerProfiles.saveOrCreate(profileName);
            class_310.method_1551().method_1507(null);
        }, "Save", scale);
        class_310 cl = class_310.method_1551();
        cl.method_1507((class_437)new VCOverlay(cl.field_1755, popup));
    }

    public static void trackerNoti(String itemName) {
        if (FishyConfig.getState("trackerNotis", false)) {
            FishyNotis.send("Tracker drop: " + itemName);
        }
    }

    private TrackerUtils() {
        throw new UnsupportedOperationException("Utility class");
    }
}

