/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.util;

import me.valkeea.fishyaddons.handler.SkyblockCleaner;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ArmorStandTweaks {
    private ArmorStandTweaks() {
    }

    public static boolean isHspt(String labelText) {
        if (labelText == null || labelText.isEmpty()) {
            return false;
        }
        if (labelText.contains("HOTSPOT")) {
            return true;
        }
        if (labelText.contains("Fishing Speed") && labelText.contains("\u2602")) {
            return true;
        }
        if (labelText.contains("\u26c3") && labelText.contains("Treasure Chance")) {
            return true;
        }
        if (labelText.contains("\u2654") && labelText.contains("Trophy Fish Chance")) {
            return true;
        }
        if (labelText.contains("Sea Creature Chance")) {
            return true;
        }
        return labelText.contains("Double Hook Chance") && labelText.contains("\u2693");
    }

    public static boolean shouldHideArmorStand(String labelText) {
        if (!ArmorStandTweaks.isValidLabel(labelText)) {
            return false;
        }
        if (!ArmorStandTweaks.isHsptHidingEnabled()) {
            return false;
        }
        if (!ArmorStandTweaks.isHspt(labelText)) {
            return false;
        }
        float configuredDistance = SkyblockCleaner.getHotspotDistance();
        if (configuredDistance <= 0.0f) {
            return true;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        return ArmorStandTweaks.isArmorStandWithinDistance(client, labelText, configuredDistance);
    }

    private static boolean isValidLabel(String labelText) {
        return labelText != null && !labelText.isEmpty();
    }

    private static boolean isHsptHidingEnabled() {
        return SkyblockCleaner.shouldHideHotspot();
    }

    private static boolean isArmorStandWithinDistance(class_310 client, String labelText, float configuredDistance) {
        for (class_1297 entity : client.field_1687.method_8390(class_1531.class, client.field_1724.method_5829().method_1014((double)configuredDistance + 1.0), e -> true)) {
            class_1531 armorStand;
            if (!(entity instanceof class_1531) || !ArmorStandTweaks.nameMatches(armorStand = (class_1531)entity, labelText)) continue;
            double distance = client.field_1724.method_5739((class_1297)armorStand);
            return distance <= (double)configuredDistance;
        }
        return false;
    }

    private static boolean nameMatches(class_1531 armorStand, String labelText) {
        String[] possibleNames;
        for (String nameToCheck : possibleNames = new String[]{armorStand.method_5477().getString(), armorStand.method_5797() != null ? armorStand.method_5797().getString() : null, armorStand.method_5476().getString()}) {
            if (nameToCheck == null || !nameToCheck.equals(labelText)) continue;
            return true;
        }
        return false;
    }
}

