/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.ItemConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class EqTextures {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FishyAddons/SkullTexture");
    private static final Map<Integer, class_2960> slotTextures = new HashMap<Integer, class_2960>();
    private static final Map<Integer, String> skullTextureUrls = new HashMap<Integer, String>();
    private static final Map<Integer, class_1799> skullItemStacks = new HashMap<Integer, class_1799>();
    private static final Map<Integer, Boolean> emptySlots = new HashMap<Integer, Boolean>();
    public static final int HELMET_SLOT = 0;
    public static final int CHESTPLATE_SLOT = 1;
    public static final int LEGGINGS_SLOT = 2;
    public static final int BOOTS_SLOT = 3;

    private EqTextures() {
    }

    public static String extractSkullTexture(class_1799 itemStack) {
        if (itemStack != null && itemStack.method_7909() == class_1802.field_8575) {
            class_9296 profile = (class_9296)itemStack.method_58695(class_9334.field_49617, null);
            if (profile == null) {
                return null;
            }
            try {
                PropertyMap properties = profile.comp_2412();
                Collection textures = properties.get((Object)"textures");
                if (textures == null || textures.isEmpty()) {
                    return null;
                }
                String value = ((Property)textures.iterator().next()).value();
                if (value.isEmpty()) {
                    return null;
                }
                byte[] decoded = Base64.getDecoder().decode(value);
                String json = new String(decoded);
                int texturesStart = json.indexOf("\"textures\"");
                if (texturesStart == -1) {
                    return null;
                }
                int skinStart = json.indexOf("\"SKIN\"", texturesStart);
                if (skinStart == -1) {
                    return null;
                }
                int urlStart = json.indexOf("\"url\"", skinStart);
                if (urlStart == -1) {
                    return null;
                }
                int colonIndex = json.indexOf(":", urlStart);
                int openQuote = json.indexOf("\"", colonIndex + 1);
                int closeQuote = json.indexOf("\"", openQuote + 1);
                if (openQuote > 0 && closeQuote > openQuote) {
                    return json.substring(openQuote + 1, closeQuote);
                }
                LOGGER.warn("Could not find URL value in SKIN object");
            }
            catch (Exception e) {
                LOGGER.warn("Failed to extract skull texture: {}", (Object)e.getMessage());
            }
            return null;
        }
        return null;
    }

    public static void saveSkullTexture(int slotIndex, class_1799 itemStack) {
        if (!FishyConfig.getState("equipmentDisplay", false)) {
            return;
        }
        String textureUrl = EqTextures.extractSkullTexture(itemStack);
        if (textureUrl != null) {
            skullTextureUrls.put(slotIndex, textureUrl);
            skullItemStacks.put(slotIndex, itemStack.method_7972());
            emptySlots.put(slotIndex, false);
            class_2960 textureId = EqTextures.createTextureFromUrl(slotIndex);
            if (textureId != null) {
                slotTextures.put(slotIndex, textureId);
            }
            ItemConfig.setEqSkull(slotIndex, textureUrl);
            ItemConfig.setEqItemData(slotIndex, "minecraft:player_head");
        }
    }

    public static void saveEmptySlot(int slotIndex) {
        if (!FishyConfig.getState("equipmentDisplay", false)) {
            return;
        }
        slotTextures.remove(slotIndex);
        skullTextureUrls.remove(slotIndex);
        skullItemStacks.remove(slotIndex);
        emptySlots.put(slotIndex, true);
        ItemConfig.clearEquipmentSlot(slotIndex);
    }

    public static boolean hasSkullTexture(int slotIndex) {
        return slotTextures.containsKey(slotIndex) || ItemConfig.hasEquipmentSkull(slotIndex);
    }

    public static boolean hasSlotData(int slotIndex) {
        return EqTextures.hasSkullTexture(slotIndex) || emptySlots.containsKey(slotIndex);
    }

    public static boolean isEmptySlot(int slotIndex) {
        return emptySlots.getOrDefault(slotIndex, false);
    }

    public static class_1799 getSlotItemStack(int slotIndex) {
        if (!skullItemStacks.containsKey(slotIndex)) {
            EqTextures.loadSlotFromConfig(slotIndex);
        }
        return skullItemStacks.get(slotIndex);
    }

    private static void loadSlotFromConfig(int slotIndex) {
        String textureUrl = ItemConfig.getEquipmentSkullTexture(slotIndex);
        if (textureUrl != null && !textureUrl.isEmpty()) {
            skullTextureUrls.put(slotIndex, textureUrl);
            class_2960 textureId = EqTextures.createTextureFromUrl(slotIndex);
            if (textureId != null) {
                slotTextures.put(slotIndex, textureId);
            }
            class_1799 skullStack = EqTextures.createSkullWithTexture(textureUrl);
            skullItemStacks.put(slotIndex, skullStack);
        }
    }

    public static void clearAll() {
        slotTextures.clear();
        skullTextureUrls.clear();
        skullItemStacks.clear();
        emptySlots.clear();
        ItemConfig.clearEquipmentSkulls();
    }

    private static class_2960 createTextureFromUrl(int slotIndex) {
        try {
            String textureUrl = skullTextureUrls.get(slotIndex);
            if (textureUrl == null) {
                return null;
            }
            String textureHash = textureUrl.substring(textureUrl.lastIndexOf(47) + 1);
            return class_2960.method_60655((String)"fishyaddons", (String)("skull_texture_" + textureHash));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create texture from URL: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Map<Integer, class_2960> getAllTextures() {
        return new HashMap<Integer, class_2960>(slotTextures);
    }

    private static void loadSkullData() {
        try {
            Map<Integer, String> persistedTextures = ItemConfig.getAllEquipmentSkullTextures();
            for (Map.Entry<Integer, String> entry : persistedTextures.entrySet()) {
                int slot = entry.getKey();
                String textureUrl = entry.getValue();
                if (textureUrl == null || textureUrl.isEmpty()) continue;
                skullTextureUrls.put(slot, textureUrl);
                class_2960 textureId = EqTextures.createTextureFromUrl(slot);
                if (textureId != null) {
                    slotTextures.put(slot, textureId);
                }
                class_1799 skullStack = EqTextures.createSkullWithTexture(textureUrl);
                skullItemStacks.put(slot, skullStack);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load skull data from ItemConfig", (Throwable)e);
        }
    }

    private static class_1799 createSkullWithTexture(String textureUrl) {
        try {
            class_1799 skull = new class_1799((class_1935)class_1802.field_8575);
            String textureJson = String.format("{\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}", textureUrl);
            String encodedTexture = Base64.getEncoder().encodeToString(textureJson.getBytes());
            GameProfile profile = new GameProfile(UUID.randomUUID(), "EquipmentSlot");
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", encodedTexture));
            class_9296 profileComponent = new class_9296(profile);
            skull.method_57379(class_9334.field_49617, (Object)profileComponent);
            return skull;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create skull with texture: {}", (Object)e.getMessage());
            return new class_1799((class_1935)class_1802.field_8575);
        }
    }

    static {
        EqTextures.loadSkullData();
    }
}

