/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLConnection;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.hud.InfoDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class ModInfo {
    private static final int CLOSE_NOTIFICATION_KEY = 88;
    private static final boolean FOR_NEW = true;
    private static String infoId = "";
    private static String infoMessage = "";
    private static boolean showInfo = false;

    private static void fetchInfo() {
        try {
            String url = "https://gist.githubusercontent.com/valkeea/dff3a7ee868b0d4bed22bd300c0119f9/raw/modinfo.json";
            URLConnection conn = URI.create(url).toURL().openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestProperty("User-Agent", "FishyAddons");
            try (InputStream in = conn.getInputStream();
                 InputStreamReader reader = new InputStreamReader(in);){
                Gson gson = new Gson();
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                Map info = (Map)gson.fromJson((Reader)reader, type);
                if (info == null || info.isEmpty() || info.size() > 100) {
                    throw new IllegalStateException("Invalid gist data");
                }
                Object idObj = info.get("infoId");
                Object msgObj = info.get("infoMessage");
                infoId = idObj != null ? String.valueOf(idObj) : "";
                infoMessage = msgObj != null ? String.valueOf(msgObj) : "";
                ModInfo.check();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void tick() {
        boolean xPressed;
        if (ModInfo.shouldShowInfo() && (xPressed = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)88))) {
            InfoDisplay.getInstance().hide();
            FishyConfig.setString("infoId", ModInfo.getInfoId());
            showInfo = false;
        }
    }

    private static void check() {
        boolean foundId;
        if (infoId == null || infoId.isEmpty()) {
            return;
        }
        String lastId = FishyConfig.getString("infoId", "");
        boolean bl = foundId = lastId != null && !lastId.isEmpty();
        if (!foundId) {
            lastId = "000000";
            foundId = true;
            FishyConfig.setString("infoId", lastId);
        }
        if (foundId) {
            try {
                int infoNum = Integer.parseInt(infoId);
                int lastNum = Integer.parseInt(lastId);
                showInfo = infoNum > lastNum;
            }
            catch (NumberFormatException e) {
                showInfo = !infoId.equals(lastId);
            }
        } else {
            showInfo = false;
        }
    }

    public static String getInfoId() {
        return infoId;
    }

    public static String getInfoMessage() {
        return infoMessage;
    }

    public static boolean shouldShowInfo() {
        return showInfo;
    }

    private ModInfo() {
        throw new UnsupportedOperationException("Utility class");
    }

    static {
        ModInfo.fetchInfo();
    }
}

