/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.LinkedHashMap;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.AlertEditScreen;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.GenericEntryList;
import me.valkeea.fishyaddons.gui.TabbedListScreen;
import me.valkeea.fishyaddons.handler.ChatAlert;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class ChatAlertEntryList
extends GenericEntryList {
    public ChatAlertEntryList(class_310 client, int width, int height, int y, int itemHeight, TabbedListScreen parentScreen) {
        super(client, width, height, y, itemHeight, parentScreen);
    }

    @Override
    public Map<String, String> getEntries() {
        Map<String, FishyConfig.AlertData> alerts = FishyConfig.getChatAlerts();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, FishyConfig.AlertData> e : alerts.entrySet()) {
            result.put(e.getKey(), e.getValue() != null && e.getValue().msg != null ? e.getValue().msg : "");
        }
        return result;
    }

    @Override
    public boolean isEntryToggled(String key) {
        return FishyConfig.isChatAlertToggled(key);
    }

    public GenericEntryList.GenericEntry getHoveredAlertEntry() {
        return (GenericEntryList.GenericEntry)this.method_37019();
    }

    public void method_47399(class_6382 builder) {
    }

    @Override
    public void setEntry(String key, String value) {
        FishyConfig.AlertData data = FishyConfig.getChatAlerts().getOrDefault(key, new FishyConfig.AlertData());
        data.msg = value;
        FishyConfig.setChatAlert(key, data);
        ChatAlert.refresh();
    }

    @Override
    public void removeEntry(String key) {
        FishyConfig.removeChatAlert(key);
        ChatAlert.refresh();
    }

    @Override
    public void toggleEntry(String key, boolean toggled) {
        FishyConfig.toggleChatAlert(key, toggled);
        ChatAlert.refresh();
    }

    @Override
    public String getAddButtonText() {
        return "+ Add Alert";
    }

    @Override
    public String getSaveButtonText() {
        return "Save";
    }

    @Override
    public String getDeleteButtonText() {
        return "Delete";
    }

    @Override
    public String getToggleOnText() {
        return "ON";
    }

    @Override
    public String getToggleOffText() {
        return "OFF";
    }

    @Override
    public String getDefaultInput() {
        return "";
    }

    @Override
    public String getDefaultOutput() {
        return "";
    }

    @Override
    public boolean isValidEntry(String input, String output) {
        return !input.isBlank();
    }

    @Override
    public class_4185 createExtraButton(GenericEntryList.GenericEntry entry) {
        return new FaButton(0, 0, 40, 20, (class_2561)class_2561.method_43470((String)"More").method_27694(style -> style.method_36139(14863081)), b -> {
            if (entry != null) {
                entry.checkAndSave();
            }
            FishyConfig.AlertData data = FishyConfig.getChatAlerts().get(entry.input);
            class_310 client = class_310.method_1551();
            if (client != null) {
                client.method_1507((class_437)new AlertEditScreen(entry.input, data, this.parentScreen));
            }
        });
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int button, TabbedListScreen screen) {
        GenericEntryList.GenericEntry entry = this.getHoveredAlertEntry();
        if (entry == null) {
            return false;
        }
        Object object = entry.inputWidget;
        if (object instanceof class_342) {
            class_342 field = (class_342)object;
            if (field.method_25402(mouseX, mouseY, button)) {
                field.method_25365(true);
                screen.method_25395((class_364)field);
                return true;
            }
        } else {
            class_4185 btn;
            object = entry.inputWidget;
            if (object instanceof class_4185 && (btn = (class_4185)object).method_25402(mouseX, mouseY, button)) {
                btn.method_25365(true);
                screen.method_25395((class_364)btn);
                return true;
            }
        }
        if (entry.outputField.method_25402(mouseX, mouseY, button)) {
            entry.outputField.method_25365(true);
            screen.method_25395((class_364)entry.outputField);
            return true;
        }
        if (entry.saveButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (entry.deleteButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (entry.toggleButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (entry.extraButton != null && entry.extraButton.method_25402(mouseX, mouseY, button)) {
            entry.extraButton.method_25365(true);
            screen.method_25395((class_364)entry.extraButton);
            return true;
        }
        return false;
    }
}

