/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class CompactSlider {
    private static final int SLIDER_WIDTH = 70;
    private static final int SLIDER_HEIGHT = 12;
    private static final int KNOB_WIDTH = 6;
    private static final int KNOB_HEIGHT = 10;
    private static final String DEFAULT_FORMAT = "%.0f%%";
    private final int x;
    private final int y;
    private float value;
    private boolean isDragging = false;
    private final ValueChangeListener listener;
    private final float minValue;
    private final float maxValue;
    private final String displayFormat;

    public CompactSlider(int x, int y, float initialValue, ValueChangeListener listener) {
        this(x, y, initialValue, 0.0f, 1.0f, DEFAULT_FORMAT, listener);
    }

    public CompactSlider(int x, int y, float initialValue, float minValue, float maxValue, String displayFormat, ValueChangeListener listener) {
        this.x = x;
        this.y = y;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.displayFormat = displayFormat;
        this.listener = listener;
        this.value = Math.clamp((initialValue - minValue) / (maxValue - minValue), 0.0f, 1.0f);
    }

    public void render(class_332 context, int mouseX, int mouseY) {
        boolean isHovered;
        context.method_25294(this.x, this.y + 4, this.x + 70, this.y + 8, -13421773);
        context.method_25294(this.x, this.y + 4, this.x + 70, this.y + 5, -10066330);
        context.method_25294(this.x, this.y + 7, this.x + 70, this.y + 8, -10066330);
        context.method_25294(this.x, this.y + 4, this.x + 1, this.y + 8, -10066330);
        context.method_25294(this.x + 70 - 1, this.y + 4, this.x + 70, this.y + 8, -10066330);
        int knobX = this.x + (int)(64.0f * this.value);
        int knobY = this.y + 1;
        boolean bl = isHovered = mouseX >= knobX && mouseX <= knobX + 6 && mouseY >= knobY && mouseY <= knobY + 10;
        int knobColor = this.isDragging ? -1 : (isHovered ? -3355444 : -5592406);
        context.method_25294(knobX, knobY, knobX + 6, knobY + 10, knobColor);
        context.method_25294(knobX, knobY, knobX + 6, knobY + 1, -10066330);
        context.method_25294(knobX, knobY + 10 - 1, knobX + 6, knobY + 10, -10066330);
        context.method_25294(knobX, knobY, knobX + 1, knobY + 10, -10066330);
        context.method_25294(knobX + 6 - 1, knobY, knobX + 6, knobY + 10, -10066330);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOver(mouseX, mouseY)) {
            this.isDragging = true;
            this.updateValue(mouseX);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(int button) {
        if (button == 0 && this.isDragging) {
            this.isDragging = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, int button) {
        if (this.isDragging && button == 0) {
            this.updateValue(mouseX);
            return true;
        }
        return false;
    }

    private void updateValue(double mouseX) {
        float newValue = (float)(mouseX - (double)this.x) / 64.0f;
        if ((newValue = Math.clamp(newValue, 0.0f, 1.0f)) != this.value) {
            this.value = newValue;
            if (this.listener != null) {
                float actualValue = this.minValue + this.value * (this.maxValue - this.minValue);
                this.listener.onValueChanged(actualValue);
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + 70) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12);
    }

    public float getValue() {
        return this.minValue + this.value * (this.maxValue - this.minValue);
    }

    public void setValue(float actualValue) {
        this.value = Math.clamp((actualValue - this.minValue) / (this.maxValue - this.minValue), 0.0f, 1.0f);
    }

    public String getPercentageText() {
        float actualValue = this.getValue();
        if (this.displayFormat.equals(DEFAULT_FORMAT)) {
            return String.format(this.displayFormat, Float.valueOf(actualValue * 100.0f));
        }
        return String.format(this.displayFormat, Float.valueOf(actualValue));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static int getWidth() {
        return 70;
    }

    public static int getHeight() {
        return 12;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ValueChangeListener {
        public void onValueChanged(float var1);
    }
}

