/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.valkeea.fishyaddons.gui.FaTextField;
import me.valkeea.fishyaddons.gui.SearchEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class SearchMenu {
    private final List<SearchEntry> allEntries;
    private List<SearchEntry> filteredEntries;
    private final int x;
    private final int y;
    private final int width;
    private final int entryHeight;
    private final Consumer<SearchEntry> onSelect;
    private int hoveredIndex = -1;
    private boolean visible = true;
    private final class_342 searchField;
    private final boolean usesExternalField;
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_ENTRIES = 8;

    public SearchMenu(List<SearchEntry> entries, int x, int y, int width, int entryHeight, Consumer<SearchEntry> onSelect, class_437 screen) {
        this(entries, x, y, width, entryHeight, onSelect, screen, null);
    }

    public SearchMenu(List<SearchEntry> entries, int x, int y, int width, int entryHeight, Consumer<SearchEntry> onSelect, class_437 screen, class_342 externalField) {
        this.allEntries = entries;
        this.filteredEntries = entries;
        this.x = x;
        this.y = y + 24;
        this.width = width;
        this.entryHeight = entryHeight;
        this.onSelect = onSelect;
        if (externalField != null) {
            this.searchField = externalField;
            this.usesExternalField = true;
        } else {
            this.searchField = new FaTextField(screen.method_64506(), x, y, width, 15, (class_2561)class_2561.method_43470((String)"Search..."));
            this.searchField.method_1868(-8355712);
            this.searchField.method_1863(this::updateFilter);
            this.usesExternalField = false;
        }
    }

    private void updateFilter(String query) {
        this.filteredEntries = this.allEntries.stream().filter(e -> e.name.toLowerCase().contains(query.toLowerCase()) || e.description != null && e.description.toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
    }

    public void render(class_332 context, class_437 screen, int mouseX, int mouseY, float delta) {
        int entryIndex;
        int visibleEntries;
        if (!this.visible) {
            return;
        }
        if (!this.searchField.method_25370() && this.searchField.method_1882().isEmpty()) {
            this.searchField.method_1852(class_2561.method_43470((String)"search...").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_36139(-8355712)).getString());
        } else if (this.searchField.method_25370() && this.searchField.method_1882().equals("search...")) {
            this.searchField.method_1852("");
        }
        if (!this.usesExternalField) {
            this.searchField.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.usesExternalField) {
            this.updateFilter(this.searchField.method_1882());
        }
        if (!this.searchField.method_25370() && !this.usesExternalField) {
            return;
        }
        class_327 textRenderer = screen.method_64506();
        int totalEntries = this.filteredEntries.size();
        int maxOffset = Math.max(0, totalEntries - (visibleEntries = Math.min(totalEntries, 8)));
        if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        int[] entryHeights = new int[visibleEntries];
        int[][] lineCounts = new int[visibleEntries][2];
        for (int i = 0; i < visibleEntries && (entryIndex = i + this.scrollOffset) < this.filteredEntries.size(); ++i) {
            SearchEntry entry = this.filteredEntries.get(entryIndex);
            int descLines = 0;
            if (entry.description != null && !entry.description.isEmpty()) {
                descLines = entry.description.split("\n").length;
            }
            entryHeights[i] = 14 + descLines * 12 + 4;
            lineCounts[i][0] = 1;
            lineCounts[i][1] = descLines;
        }
        this.hoveredIndex = -1;
        int currentY = this.y;
        for (int i = 0; i < visibleEntries; ++i) {
            int entryIndex2 = i + this.scrollOffset;
            SearchEntry entry = this.filteredEntries.get(entryIndex2);
            int entryHeight = entryHeights[i];
            boolean hovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= currentY && mouseY <= currentY + entryHeight;
            int bgColor = hovered ? -1914135 : -299752926;
            context.method_25294(this.x, currentY, this.x + this.width, currentY + entryHeight, bgColor);
            int textColor = hovered ? -16777216 : -1914135;
            context.method_51433(textRenderer, entry.name, this.x + 6, currentY + 2, textColor, false);
            if (entry.description != null && !entry.description.isEmpty()) {
                String[] lines = entry.description.split("\n");
                int descColor = hovered ? -1118482 : -3355444;
                for (int l = 0; l < lines.length; ++l) {
                    context.method_51433(textRenderer, lines[l], this.x + 8, currentY + 16 + l * 12, descColor, false);
                }
            }
            if (hovered) {
                this.hoveredIndex = entryIndex2;
            }
            currentY += entryHeight;
        }
        if (totalEntries > 8) {
            context.method_25294(this.x, currentY, this.x + this.width, currentY + 18, -870178270);
            context.method_51433(textRenderer, ". . .", this.x + 10, currentY + 4, -4478260, false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        int visibleEntries;
        if (keyCode == 256) {
            if (this.searchField.method_25370()) {
                this.searchField.method_25365(false);
                return true;
            }
            return false;
        }
        int totalEntries = this.filteredEntries.size();
        int maxOffset = Math.max(0, totalEntries - (visibleEntries = Math.min(totalEntries, 8)));
        if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (keyCode == 264) {
            if (this.scrollOffset < maxOffset) {
                ++this.scrollOffset;
                return true;
            }
        } else if (keyCode == 265 && this.scrollOffset > 0) {
            --this.scrollOffset;
            return true;
        }
        return this.searchField.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int entryIndex;
        if (!this.visible) {
            return false;
        }
        int totalEntries = this.filteredEntries.size();
        int visibleEntries = Math.min(totalEntries, 8);
        int[] entryHeights = new int[visibleEntries];
        int currentY = this.y;
        for (int i = 0; i < visibleEntries && (entryIndex = i + this.scrollOffset) < this.filteredEntries.size(); ++i) {
            SearchEntry entry = this.filteredEntries.get(entryIndex);
            int descLines = 0;
            if (entry.description != null && !entry.description.isEmpty()) {
                descLines = entry.description.split("\n").length;
            }
            entryHeights[i] = 14 + descLines * 12 + 4;
        }
        int entryTop = this.y;
        for (int i = 0; i < visibleEntries; ++i) {
            int entryIndex2 = i + this.scrollOffset;
            int entryHeight = entryHeights[i];
            int entryBottom = entryTop + entryHeight;
            if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)entryTop && mouseY <= (double)entryBottom) {
                this.onSelect.accept(this.filteredEntries.get(entryIndex2));
                this.searchField.method_25365(false);
                return true;
            }
            entryTop = entryBottom;
        }
        if (!(mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.searchField.method_46427() && mouseY <= (double)(this.searchField.method_46427() + this.searchField.method_25364()))) {
            this.searchField.method_25365(false);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int visibleEntries;
        if (!this.visible) {
            return false;
        }
        int totalEntries = this.filteredEntries.size();
        if (totalEntries > (visibleEntries = Math.min(totalEntries, 8))) {
            this.scrollOffset -= (int)amount;
            int maxOffset = totalEntries - visibleEntries;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > maxOffset) {
                this.scrollOffset = maxOffset;
            }
            return true;
        }
        return false;
    }

    public class_342 getSearchField() {
        return this.searchField;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public List<SearchEntry> getFilteredEntries() {
        return this.filteredEntries;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getEntryHeight() {
        return this.entryHeight;
    }

    public Consumer<SearchEntry> getOnSelect() {
        return this.onSelect;
    }

    public int getHoveredIndex() {
        return this.hoveredIndex;
    }
}

