/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.List;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.FishyPresets;
import me.valkeea.fishyaddons.gui.AliasEntryList;
import me.valkeea.fishyaddons.gui.ChatAlertEntryList;
import me.valkeea.fishyaddons.gui.ChatEntryList;
import me.valkeea.fishyaddons.gui.DropdownMenu;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.FaTextField;
import me.valkeea.fishyaddons.gui.FishyPopup;
import me.valkeea.fishyaddons.gui.GenericEntryList;
import me.valkeea.fishyaddons.gui.GuiUtil;
import me.valkeea.fishyaddons.gui.KeybindEntryList;
import me.valkeea.fishyaddons.gui.QolScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class TabbedListScreen
extends class_437 {
    private Tab currentTab = Tab.COMMANDS;
    private AliasEntryList commandEntryList;
    private KeybindEntryList keybindEntryList;
    private ChatEntryList chatEntryList;
    private ChatAlertEntryList alertEntryList;
    private final class_437 parent;
    protected boolean addingNewEntry = false;
    protected FishyPopup fishyPopup = null;
    private DropdownMenu presetDropdown;
    private class_342 presetNameField;

    public TabbedListScreen(class_437 parent, Tab tab) {
        super((class_2561)class_2561.method_43470((String)"Aliases, Keybinds, Chat Replacements, Alerts"));
        this.parent = parent;
        this.currentTab = tab;
    }

    protected void method_25426() {
        int listWidth = 700;
        int listHeight = this.field_22790 - 120;
        int listY = 70;
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 - 200, 40, 80, 20, (class_2561)class_2561.method_43470((String)"Commands"), b -> this.switchTab(Tab.COMMANDS)));
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 - 95, 40, 80, 20, (class_2561)class_2561.method_43470((String)"Keybinds"), b -> this.switchTab(Tab.KEYBINDS)));
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 + 10, 40, 80, 20, (class_2561)class_2561.method_43470((String)"Chat"), b -> this.switchTab(Tab.CHAT)));
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 + 105, 40, 80, 20, (class_2561)class_2561.method_43470((String)"Alerts"), b -> this.switchTab(Tab.ALERT)));
        this.commandEntryList = new AliasEntryList(class_310.method_1551(), listWidth, listHeight, listY, 24, this);
        this.keybindEntryList = new KeybindEntryList(class_310.method_1551(), listWidth, listHeight, listY, 24, this);
        this.chatEntryList = new ChatEntryList(class_310.method_1551(), listWidth, listHeight, listY, 24, this);
        this.alertEntryList = new ChatAlertEntryList(class_310.method_1551(), listWidth, listHeight, listY, 24, this);
        this.commandEntryList.method_48229((this.field_22789 - listWidth) / 2, listY);
        this.keybindEntryList.method_48229((this.field_22789 - listWidth) / 2, listY);
        this.chatEntryList.method_48229((this.field_22789 - listWidth) / 2, listY);
        this.alertEntryList.method_48229((this.field_22789 - listWidth) / 2, listY);
        this.commandEntryList.refreshWithAdd();
        this.keybindEntryList.refreshWithAdd();
        this.chatEntryList.refreshWithAdd();
        this.alertEntryList.refreshWithAdd();
        this.method_37063((class_364)this.commandEntryList);
        this.method_37063((class_364)this.keybindEntryList);
        this.method_37063((class_364)this.chatEntryList);
        this.method_37063((class_364)this.alertEntryList);
        this.updateTabVisibility();
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 - 80, this.field_22790 - 30, 80, 20, (class_2561)class_2561.method_43470((String)"Back").method_27694(style -> style.method_36139(-5197648)), b -> this.field_22787.method_1507((class_437)new QolScreen())));
        this.method_37063((class_364)new FaButton(this.field_22789 / 2, this.field_22790 - 30, 80, 20, (class_2561)class_2561.method_43470((String)"Close").method_27694(style -> style.method_36139(-5197648)), b -> this.field_22787.method_1507(null)));
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 + 205, this.field_22790 - 30, 100, 20, (class_2561)class_2561.method_43470((String)"Load From Preset").method_27694(style -> style.method_36139(14863081)), b -> this.showPresetDropdown()));
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 + 105, this.field_22790 - 30, 100, 20, (class_2561)class_2561.method_43470((String)"Save as Preset").method_27694(style -> style.method_36139(0xB0FFB0)), b -> this.showSavePresetPopup()));
        this.field_22787.execute(this::refreshEntryList);
    }

    private void switchTab(Tab tab) {
        this.currentTab = tab;
        if (this.fishyPopup != null) {
            this.fishyPopup = null;
        }
        this.updateTabVisibility();
        this.field_22787.execute(this::refreshEntryList);
        this.method_25395(null);
    }

    private void updateTabVisibility() {
        if (this.commandEntryList != null) {
            boolean bl = this.commandEntryList.field_22764 = this.currentTab == Tab.COMMANDS;
        }
        if (this.keybindEntryList != null) {
            boolean bl = this.keybindEntryList.field_22764 = this.currentTab == Tab.KEYBINDS;
        }
        if (this.chatEntryList != null) {
            boolean bl = this.chatEntryList.field_22764 = this.currentTab == Tab.CHAT;
        }
        if (this.alertEntryList != null) {
            this.alertEntryList.field_22764 = this.currentTab == Tab.ALERT;
        }
    }

    protected void refreshEntryList() {
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.commandEntryList.refreshWithAdd();
                break;
            }
            case 1: {
                this.keybindEntryList.refreshWithAdd();
                break;
            }
            case 2: {
                this.chatEntryList.refreshWithAdd();
                break;
            }
            case 3: {
                this.alertEntryList.refreshWithAdd();
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, -11141121);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.presetDropdown != null && this.presetDropdown.isVisible()) {
            this.presetDropdown.render(context, this, mouseX, mouseY);
        }
        if (this.fishyPopup == null) {
            if (this.currentTab == Tab.COMMANDS) {
                for (GenericEntryList.GenericEntry entry : this.commandEntryList.method_25396()) {
                    if (!(entry instanceof GenericEntryList.GenericEntry)) continue;
                    GenericEntryList.GenericEntry ge = entry;
                    if (ge.pendingTooltip == null) continue;
                    GuiUtil.fishyTooltip(context, this.field_22793, ge.tooltipLines != null ? ge.tooltipLines : List.of(class_2561.method_43470((String)ge.pendingTooltip)), ge.tooltipX, ge.tooltipY);
                    break;
                }
            } else if (this.currentTab == Tab.KEYBINDS) {
                for (GenericEntryList.GenericEntry entry : this.keybindEntryList.method_25396()) {
                    if (!(entry instanceof GenericEntryList.GenericEntry)) continue;
                    GenericEntryList.GenericEntry ge = entry;
                    if (ge.pendingTooltip == null) continue;
                    GuiUtil.fishyTooltip(context, this.field_22793, ge.tooltipLines != null ? ge.tooltipLines : List.of(class_2561.method_43470((String)ge.pendingTooltip)), ge.tooltipX, ge.tooltipY);
                    break;
                }
            } else if (this.currentTab == Tab.CHAT) {
                for (GenericEntryList.GenericEntry entry : this.chatEntryList.method_25396()) {
                    if (!(entry instanceof GenericEntryList.GenericEntry)) continue;
                    GenericEntryList.GenericEntry ge = entry;
                    if (ge.pendingTooltip == null) continue;
                    GuiUtil.fishyTooltip(context, this.field_22793, ge.tooltipLines != null ? ge.tooltipLines : List.of(class_2561.method_43470((String)ge.pendingTooltip)), ge.tooltipX, ge.tooltipY);
                    break;
                }
            } else if (this.currentTab == Tab.ALERT) {
                for (GenericEntryList.GenericEntry entry : this.alertEntryList.method_25396()) {
                    if (!(entry instanceof GenericEntryList.GenericEntry)) continue;
                    GenericEntryList.GenericEntry ge = entry;
                    if (ge.pendingTooltip == null) continue;
                    GuiUtil.fishyTooltip(context, this.field_22793, ge.tooltipLines != null ? ge.tooltipLines : List.of(class_2561.method_43470((String)ge.pendingTooltip)), ge.tooltipX, ge.tooltipY);
                    break;
                }
            }
        }
        if (this.fishyPopup != null) {
            this.method_25420(context, mouseX, mouseY, delta);
            this.fishyPopup.render(context, this.field_22793, mouseX, mouseY, delta);
        }
        if (this.fishyPopup != null && this.presetNameField != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            this.presetNameField.method_46421(this.fishyPopup.getX() + (this.fishyPopup.getWidth() - this.presetNameField.method_25368()) / 2);
            this.presetNameField.method_46419(this.fishyPopup.getY() + 35);
            this.presetNameField.method_25394(context, mouseX, mouseY, delta);
            context.method_51448().method_22909();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.fishyPopup != null && this.presetNameField != null && this.presetNameField.method_25402(mouseX, mouseY, button)) {
            this.presetNameField.method_25365(true);
            this.method_25395((class_364)this.presetNameField);
            return true;
        }
        if (this.presetDropdown != null && this.presetDropdown.isVisible()) {
            if (this.presetDropdown.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            int x = this.presetDropdown.getX();
            int y = this.presetDropdown.getY();
            int w = this.presetDropdown.getWidth();
            int h = this.presetDropdown.getEntryHeight() * this.presetDropdown.getEntries().size();
            if (!(mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h))) {
                this.presetDropdown.setVisible(false);
                return true;
            }
        }
        if (this.fishyPopup != null) {
            return this.fishyPopup.mouseClicked(mouseX, mouseY, button);
        }
        if (this.currentTab == Tab.COMMANDS ? this.commandEntryList.handleMouseClicked(mouseX, mouseY, button, this) : (this.currentTab == Tab.KEYBINDS ? this.keybindEntryList.handleMouseClicked(mouseX, mouseY, button, this) : (this.currentTab == Tab.CHAT ? this.chatEntryList.handleMouseClicked(mouseX, mouseY, button, this) : this.currentTab == Tab.ALERT && this.alertEntryList.handleMouseClicked(mouseX, mouseY, button, this)))) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.fishyPopup != null && this.presetNameField != null) {
            return this.presetNameField.method_25404(keyCode, scanCode, modifiers);
        }
        GenericEntryList.GenericEntry entry = null;
        if (this.currentTab == Tab.COMMANDS) {
            entry = (GenericEntryList.GenericEntry)this.commandEntryList.method_25336();
        } else if (this.currentTab == Tab.KEYBINDS) {
            entry = (GenericEntryList.GenericEntry)this.keybindEntryList.method_25336();
        } else if (this.currentTab == Tab.CHAT) {
            entry = (GenericEntryList.GenericEntry)this.chatEntryList.method_25336();
        } else if (this.currentTab == Tab.ALERT) {
            entry = (GenericEntryList.GenericEntry)this.alertEntryList.method_25336();
        }
        if (entry != null) {
            class_4185 btn;
            class_342 field;
            if (entry.outputField.method_25370() && entry.outputField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            Object object = entry.inputWidget;
            if (object instanceof class_342 && (field = (class_342)object).method_25370() && field.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            object = entry.inputWidget;
            if (object instanceof class_4185 && (btn = (class_4185)object).method_25370() && btn.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (entry.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        class_350.class_351 field;
        if (this.fishyPopup != null && this.presetNameField != null) {
            return this.presetNameField.method_25400(chr, modifiers);
        }
        if (this.currentTab == Tab.COMMANDS) {
            class_350.class_351 class_3512 = this.commandEntryList.method_25336();
            if (class_3512 instanceof GenericEntryList.GenericEntry) {
                class_342 field2;
                GenericEntryList.GenericEntry entry = (GenericEntryList.GenericEntry)class_3512;
                if (entry.outputField.method_25370() && entry.outputField.method_25400(chr, modifiers)) {
                    return true;
                }
                Object object = entry.inputWidget;
                if (object instanceof class_342 && (field2 = (class_342)object).method_25370() && field2.method_25400(chr, modifiers)) {
                    return true;
                }
            }
        } else if (this.currentTab == Tab.KEYBINDS) {
            class_350.class_351 field2 = this.keybindEntryList.method_25336();
            if (field2 instanceof GenericEntryList.GenericEntry) {
                GenericEntryList.GenericEntry entry = (GenericEntryList.GenericEntry)field2;
                if (entry.outputField.method_25370() && entry.outputField.method_25400(chr, modifiers)) {
                    return true;
                }
                Object object = entry.inputWidget;
                if (object instanceof class_342 && (field2 = (class_342)object).method_25370() && field2.method_25400(chr, modifiers)) {
                    return true;
                }
            }
        } else if (this.currentTab == Tab.CHAT) {
            class_350.class_351 field3 = this.chatEntryList.method_25336();
            if (field3 instanceof GenericEntryList.GenericEntry) {
                GenericEntryList.GenericEntry entry = (GenericEntryList.GenericEntry)field3;
                if (entry.outputField.method_25370() && entry.outputField.method_25400(chr, modifiers)) {
                    return true;
                }
                Object object = entry.inputWidget;
                if (object instanceof class_342 && (field3 = (class_342)object).method_25370() && field3.method_25400(chr, modifiers)) {
                    return true;
                }
            }
        } else if (this.currentTab == Tab.ALERT && (field = this.alertEntryList.method_25336()) instanceof GenericEntryList.GenericEntry) {
            GenericEntryList.GenericEntry entry = (GenericEntryList.GenericEntry)field;
            if (entry.outputField.method_25370() && entry.outputField.method_25400(chr, modifiers)) {
                return true;
            }
            Object object = entry.inputWidget;
            if (object instanceof class_342 && (field = (class_342)object).method_25370() && field.method_25400(chr, modifiers)) {
                return true;
            }
        }
        return super.method_25400(chr, modifiers);
    }

    public void showFishyPopup(class_2561 title, class_2561 continueButtonText, Runnable onContinue, class_2561 discardButtonText, Runnable onDiscard) {
        this.fishyPopup = new FishyPopup(title, continueButtonText, onContinue, discardButtonText, onDiscard);
        this.fishyPopup.init(this.field_22789, this.field_22790);
    }

    private void showPresetDropdown() {
        FishyPresets.PresetType type = switch (this.currentTab.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> FishyPresets.PresetType.COMMANDS;
            case 1 -> FishyPresets.PresetType.KEYBINDS;
            case 2 -> FishyPresets.PresetType.CHAT;
            case 3 -> FishyPresets.PresetType.ALERT;
        };
        List<String> suffixes = FishyPresets.listPresetSuffixes(type);
        if (suffixes.isEmpty()) {
            this.showFishyPopup((class_2561)class_2561.method_43470((String)"No presets found for this tab."), (class_2561)class_2561.method_43470((String)"OK"), () -> {
                this.fishyPopup = null;
            }, (class_2561)class_2561.method_43470((String)""), () -> {});
            return;
        }
        int dropdownX = this.field_22789 / 2 + 205;
        int dropdownY = this.field_22790 - 40 - suffixes.size() * 14 / 2;
        this.presetDropdown = new DropdownMenu(suffixes, dropdownX, dropdownY, 100, 14, suffix -> {
            this.loadPresetForCurrentTab((String)suffix);
            this.refreshEntryList();
            this.presetDropdown.setVisible(false);
        });
    }

    private void loadPresetForCurrentTab(String suffix) {
        switch (this.currentTab.ordinal()) {
            case 0: {
                Map<String, String> map = FishyPresets.loadStringPreset(FishyPresets.PresetType.COMMANDS, suffix);
                if (map == null) break;
                FishyConfig.commandAliases.getValues().putAll(map);
                FishyConfig.save();
                this.commandEntryList.refreshWithAdd();
                break;
            }
            case 1: {
                Map<String, String> map = FishyPresets.loadStringPreset(FishyPresets.PresetType.KEYBINDS, suffix);
                if (map == null) break;
                FishyConfig.keybinds.getValues().putAll(map);
                FishyConfig.save();
                this.keybindEntryList.refreshWithAdd();
                break;
            }
            case 2: {
                Map<String, String> map = FishyPresets.loadStringPreset(FishyPresets.PresetType.CHAT, suffix);
                if (map == null) break;
                FishyConfig.chatReplacements.getValues().putAll(map);
                FishyConfig.save();
                this.chatEntryList.refreshWithAdd();
                break;
            }
            case 3: {
                Map<String, FishyConfig.AlertData> map = FishyPresets.loadAlertPreset(suffix);
                if (map == null) break;
                FishyConfig.chatAlerts.getValues().putAll(map);
                FishyConfig.save();
                this.alertEntryList.refreshWithAdd();
            }
        }
    }

    private void showSavePresetPopup() {
        this.presetNameField = new FaTextField(this.field_22793, this.field_22789 / 2 - 60, this.field_22790 / 2, 120, 20, (class_2561)class_2561.method_43470((String)"Preset Name"));
        this.presetNameField.method_1880(32);
        this.presetNameField.method_1852("");
        this.method_25395((class_364)this.presetNameField);
        this.showFishyPopup((class_2561)class_2561.method_43470((String)"Enter preset name:"), (class_2561)class_2561.method_43470((String)"Save"), () -> {
            String suffix = this.presetNameField.method_1882().trim();
            if (!suffix.isEmpty()) {
                this.saveCurrentTabAsPreset(suffix);
            }
            this.fishyPopup = null;
            this.method_37066((class_364)this.presetNameField);
            this.presetNameField = null;
        }, (class_2561)class_2561.method_43470((String)"Cancel"), () -> {
            this.fishyPopup = null;
            this.method_37066((class_364)this.presetNameField);
            this.presetNameField = null;
        });
    }

    private void saveCurrentTabAsPreset(String suffix) {
        switch (this.currentTab.ordinal()) {
            case 0: {
                FishyPresets.saveStringPreset(FishyPresets.PresetType.COMMANDS, suffix, FishyConfig.commandAliases.getValues());
                break;
            }
            case 1: {
                FishyPresets.saveStringPreset(FishyPresets.PresetType.KEYBINDS, suffix, FishyConfig.keybinds.getValues());
                break;
            }
            case 2: {
                FishyPresets.saveStringPreset(FishyPresets.PresetType.CHAT, suffix, FishyConfig.chatReplacements.getValues());
                break;
            }
            case 3: {
                FishyPresets.saveAlertPreset(suffix, FishyConfig.chatAlerts.getValues());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Tab {
        COMMANDS,
        KEYBINDS,
        CHAT,
        ALERT;

    }
}

