/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.HashMap;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.ColorPickerScreen;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.FishyAddonsScreen;
import me.valkeea.fishyaddons.gui.GuiUtil;
import me.valkeea.fishyaddons.gui.ThemedSlider;
import me.valkeea.fishyaddons.handler.ParticleVisuals;
import me.valkeea.fishyaddons.handler.ResourceHandler;
import me.valkeea.fishyaddons.handler.XpColor;
import me.valkeea.fishyaddons.tool.FishyMode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class VisualSettingsScreen
extends class_437 {
    private static final int BTNW = 200;
    private static final int BTNH = 20;
    private final Map<class_4185, String> islandButtons = new HashMap<class_4185, String>();

    public VisualSettingsScreen() {
        super((class_2561)class_2561.method_43470((String)"Visual Settings"));
    }

    protected void method_25426() {
        this.method_37067();
        this.islandButtons.clear();
        int centerX = this.field_22789 / 2;
        int y = this.field_22790 / 4;
        this.method_37063((class_364)new FaButton(centerX - 300, y, 200, 20, this.getLavaToggleText(), btn -> {
            FishyConfig.toggle("fishyLava", false);
            btn.method_25355(this.getLavaToggleText());
        }));
        this.method_37063((class_364)new FaButton(centerX - 100, y, 200, 20, this.getFontText(), btn -> {
            FishyConfig.toggle("hdFont", false);
            ResourceHandler.updateFontPack();
            btn.method_25355(this.getFontText());
        }));
        this.method_37063((class_364)new FaButton(centerX + 100, y, 200, 20, this.getGuiText(), btn -> {
            FishyConfig.toggle("fishyGui", false);
            ResourceHandler.updateGuiPack();
            btn.method_25355(this.getGuiText());
        }));
        this.method_37063((class_364)new ParticleColorSlider(centerX - 100, y += 70, 200, 20, "Redstone Particle Color", 0, 4, FishyConfig.getCustomParticleColorIndex()));
        this.method_37063((class_364)new FaButton(centerX + 100, y, 60, 20, VisualSettingsScreen.getCustomButtonText(), btn -> class_310.method_1551().method_1507((class_437)new ColorPickerScreen(this, ParticleVisuals.getActiveParticleColor(), color -> {
            ParticleVisuals.setCustomColor(color);
            btn.method_25355(VisualSettingsScreen.getCustomButtonText());
        }))));
        this.method_37063((class_364)new ThemeModeSlider(centerX - 100, y += 30, 200, 20));
        this.method_37063((class_364)new FaButton(centerX - 100, y += 30, 200, 20, VisualSettingsScreen.getXpColorText(), btn -> {
            XpColor.toggle();
            XpColor.refresh();
            btn.method_25355(VisualSettingsScreen.getXpColorText());
        }));
        this.method_37063((class_364)new FaButton(centerX + 100, y, 60, 20, VisualSettingsScreen.getCustomXpColorText(), btn -> class_310.method_1551().method_1507((class_437)new ColorPickerScreen(this, ColorPickerScreen.intToRGB(XpColor.get()), color -> {
            XpColor.set(ColorPickerScreen.rgbToInt(color));
            btn.method_25355(VisualSettingsScreen.getCustomXpColorText());
        }))));
        this.method_37063((class_364)new FaButton(centerX + 160, y, 60, 20, VisualSettingsScreen.getOutlineText(), btn -> {
            XpColor.toggleOutline();
            XpColor.refresh();
            btn.method_25355(VisualSettingsScreen.getOutlineText());
        }));
        this.method_37063((class_364)new FaButton(centerX - 100, y += 60, 80, 20, (class_2561)class_2561.method_43470((String)"Back"), btn -> class_310.method_1551().method_1507((class_437)new FishyAddonsScreen())));
        this.method_37063((class_364)new FaButton(centerX + 20, y, 80, 20, (class_2561)class_2561.method_43470((String)"Close"), btn -> class_310.method_1551().method_1507(null)));
    }

    private class_2561 getFontText() {
        return GuiUtil.onOffLabel("HD Font", FishyConfig.getState("hdFont", false));
    }

    private class_2561 getGuiText() {
        return GuiUtil.onOffLabel("Transparent Gui", FishyConfig.getState("fishyGui", false));
    }

    private class_2561 getLavaToggleText() {
        return GuiUtil.onOffLabel("Clear Lava", FishyConfig.getState("fishyLava", false));
    }

    private static class_2561 getCustomButtonText() {
        if ("custom".equals(FishyConfig.getParticleColorMode())) {
            float[] rgb = FishyConfig.getCustomParticleRGB();
            int r = (int)(rgb[0] * 255.0f);
            int g = (int)(rgb[1] * 255.0f);
            int b = (int)(rgb[2] * 255.0f);
            int color = 0xFF000000 | r << 16 | g << 8 | b;
            return class_2561.method_43470((String)"Custom").method_27694(style -> style.method_36139(color));
        }
        return class_2561.method_43470((String)"Custom");
    }

    private static class_2561 getXpColorText() {
        return GuiUtil.onOffLabel("XP Color", FishyConfig.getState("xpColorEnabled", false));
    }

    private static class_2561 getCustomXpColorText() {
        return class_2561.method_43470((String)"Custom").method_27694(style -> style.method_36139(XpColor.get()));
    }

    private static class_2561 getOutlineText() {
        boolean isEnabled = FishyConfig.getState("xpOutline", false);
        String title = "Outline";
        return class_2561.method_43470((String)title).method_27694(s -> s.method_36139(isEnabled ? 0xCCFFCC : 0xFF8080));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        String title = "Visual Settings";
        context.method_25300(this.field_22793, title, this.field_22789 / 2, this.field_22790 / 4 - 20, -11141121);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    @Environment(value=EnvType.CLIENT)
    private static class ParticleColorSlider
    extends ThemedSlider {
        private final String prefix;
        private final int min;
        private final int max;

        public ParticleColorSlider(int x, int y, int width, int height, String prefix, int min, int max, int value) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), (double)(value - min) / (double)(max - min));
            this.prefix = prefix;
            this.min = min;
            this.max = max;
            this.field_22753 = (double)(value - min) / (double)(max - min);
            this.method_25346();
        }

        protected void method_25346() {
            if ("custom".equals(FishyConfig.getParticleColorMode())) {
                float[] rgb = FishyConfig.getCustomParticleRGB();
                int r = (int)(rgb[0] * 255.0f);
                int g = (int)(rgb[1] * 255.0f);
                int b = (int)(rgb[2] * 255.0f);
                int color = 0xFF000000 | r << 16 | g << 8 | b;
                this.method_25355((class_2561)class_2561.method_43470((String)(this.prefix + ": Custom")).method_27694(style -> style.method_36139(color)));
            } else {
                String presetName;
                int idx = (int)(this.field_22753 * (double)(this.max - this.min) + (double)this.min);
                this.method_25355((class_2561)class_2561.method_43470((String)(this.prefix + ": " + presetName)).method_27694(arg_0 -> ParticleColorSlider.lambda$updateMessage$1(switch (idx) {
                    case 1 -> {
                        presetName = "Aqua";
                        yield -10027009;
                    }
                    case 2 -> {
                        presetName = "Mint";
                        yield -10027111;
                    }
                    case 3 -> {
                        presetName = "Pink";
                        yield -13057;
                    }
                    case 4 -> {
                        presetName = "Prism";
                        yield -1710593;
                    }
                    default -> {
                        presetName = "None";
                        yield -1;
                    }
                }, arg_0)));
                FishyConfig.setParticleColorMode(idx == 0 ? "default" : "preset");
            }
        }

        protected void method_25344() {
            int idx = (int)(this.field_22753 * (double)(this.max - this.min) + (double)this.min);
            FishyConfig.setCustomParticleColorIndex(idx);
            if ("custom".equals(FishyConfig.getParticleColorMode())) {
                FishyConfig.setParticleColorMode("preset");
            }
        }

        private static /* synthetic */ class_2583 lambda$updateMessage$1(int color, class_2583 style) {
            return style.method_36139(color);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThemeModeSlider
    extends ThemedSlider {
        private static final String[] MODES = new String[]{"default", "purple", "blue", "white", "green"};

        public ThemeModeSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), ThemeModeSlider.getInitialValue());
            this.method_25346();
        }

        private static double getInitialValue() {
            String current = FishyMode.getTheme();
            for (int i = 0; i < MODES.length; ++i) {
                if (!MODES[i].equalsIgnoreCase(current)) continue;
                return (double)i / (double)(MODES.length - 1);
            }
            return 0.0;
        }

        protected void method_25346() {
            String mode;
            int idx = (int)(this.field_22753 * (double)(MODES.length - 1) + 0.5);
            String color = switch (mode = MODES[Math.clamp((long)idx, 0, MODES.length - 1)]) {
                case "purple" -> "BB80DF";
                case "blue" -> "A2C8FF";
                case "white" -> "E5E5FF";
                case "green" -> "A2FFA2";
                default -> "E2CAE9";
            };
            this.method_25355((class_2561)class_2561.method_43470((String)("Mod Gui Theme: " + ThemeModeSlider.capitalize(mode))).method_27694(style -> style.method_36139(Integer.parseInt(color, 16))));
        }

        protected void method_25344() {
            int idx = (int)(this.field_22753 * (double)(MODES.length - 1) + 0.5);
            String mode = MODES[Math.clamp((long)idx, 0, MODES.length - 1)];
            FishyMode.setTheme(mode);
            this.method_25346();
        }

        private static String capitalize(String s) {
            return s.substring(0, 1).toUpperCase() + s.substring(1);
        }
    }
}

