/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import me.valkeea.fishyaddons.hud.FishyToast;
import me.valkeea.fishyaddons.util.PlaySound;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ChatTimers {
    private static final ChatTimers INSTANCE = new ChatTimers();
    private long timerStart = 0L;
    private boolean timerAlerted = false;

    private ChatTimers() {
    }

    public static ChatTimers getInstance() {
        return INSTANCE;
    }

    public void beaconStart() {
        if (this.timerStart == 0L) {
            this.timerStart = System.currentTimeMillis();
            this.timerAlerted = false;
        }
    }

    public long getBeaconTimer() {
        if (this.timerStart == 0L) {
            return 0L;
        }
        long elapsed = (System.currentTimeMillis() - this.timerStart) / 1000L;
        long secondsLeft = 600L - elapsed;
        return Math.max(secondsLeft, 0L);
    }

    public boolean isBeaconActive() {
        return this.timerStart > 0L;
    }

    public void checkTimerAlert() {
        long timer = this.getBeaconTimer();
        if (timer == 0L && !this.timerAlerted && this.timerStart != 0L) {
            this.timerAlerted = true;
            FishyToast.show("\u00a7b\u00a7lMoonglade Beacon Alarm", "Cooldown has been reset!");
            PlaySound.beaconAlarm();
            this.timerStart = 0L;
        } else if (timer > 0L) {
            this.timerAlerted = false;
        }
    }
}

