/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.hud.ElementRegistry;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.SearchHudElement;
import me.valkeea.fishyaddons.mixin.HandledScreenAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class ItemSearchOverlay {
    private static ItemSearchOverlay instance;
    private String lastSearchTerm = "";
    private Set<Integer> matchingSlots = new HashSet<Integer>();
    private boolean isSearching = false;
    private SearchHudElement searchHudElement;
    private long lastSlotContentHash = 0L;
    private static final String OVERLAY_OPACITY_CONFIG_KEY = "searchOverlayOpacity";
    private static final float DEFAULT_OVERLAY_OPACITY = 0.5f;

    private ItemSearchOverlay() {
        for (HudElement element : ElementRegistry.getElements()) {
            SearchHudElement searchElement;
            if (!(element instanceof SearchHudElement)) continue;
            this.searchHudElement = searchElement = (SearchHudElement)element;
            break;
        }
    }

    public static ItemSearchOverlay getInstance() {
        if (instance == null) {
            instance = new ItemSearchOverlay();
        }
        return instance;
    }

    public float getOpacity() {
        return FishyConfig.getFloat(OVERLAY_OPACITY_CONFIG_KEY, 0.5f);
    }

    public void setOpacity(float opacity) {
        FishyConfig.setFloat(OVERLAY_OPACITY_CONFIG_KEY, Math.clamp(opacity, 0.0f, 1.0f));
    }

    public void render(class_332 context, class_465<?> screen, int mouseX, int mouseY, float delta) {
        if (!this.isEnabled()) {
            return;
        }
        this.ensureSearchHudElement();
        String currentSearchTerm = this.searchHudElement != null ? this.searchHudElement.getSearchTerm() : "";
        boolean overlayActive = this.searchHudElement != null && this.searchHudElement.isOverlayActive();
        long currentSlotContentHash = this.calculateSlotContentHash(screen);
        if (!currentSearchTerm.equals(this.lastSearchTerm) || currentSlotContentHash != this.lastSlotContentHash) {
            this.updateSearch(currentSearchTerm, screen);
            this.lastSearchTerm = currentSearchTerm;
            this.lastSlotContentHash = currentSlotContentHash;
        }
        if (overlayActive && this.isSearching && !currentSearchTerm.isEmpty()) {
            this.renderSearchOverlay(context, screen);
        }
    }

    private void updateSearch(String searchTerm, class_465<?> screen) {
        this.matchingSlots.clear();
        boolean bl = this.isSearching = !searchTerm.isEmpty();
        if (!this.isSearching) {
            return;
        }
        String lowerSearchTerm = searchTerm.toLowerCase();
        for (class_1735 slot : screen.method_17577().field_7761) {
            class_1799 stack = slot.method_7677();
            if (stack == null || stack.method_7960() || !this.matchesSearch(stack, lowerSearchTerm)) continue;
            this.matchingSlots.add(slot.field_7874);
        }
    }

    private boolean matchesSearch(class_1799 stack, String searchTerm) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        String itemName = stack.method_7964().getString().toLowerCase();
        if (itemName.contains(searchTerm)) {
            return true;
        }
        try {
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1724 != null) {
                List tooltip = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)client.field_1724, (class_1836)class_1836.field_41070);
                for (class_2561 line : tooltip) {
                    if (!line.getString().toLowerCase().contains(searchTerm)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void renderSearchOverlay(class_332 context, class_465<?> screen) {
        if (!this.isSearching || this.lastSearchTerm.isEmpty()) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 300.0f);
        HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
        int guiX = accessor.getX();
        int guiY = accessor.getY();
        HashSet<Rectangle> excludedAreas = new HashSet<Rectangle>();
        for (class_1735 slot : screen.method_17577().field_7761) {
            if (!this.matchingSlots.contains(slot.field_7874)) continue;
            int slotScreenX = guiX + slot.field_7873;
            int slotScreenY = guiY + slot.field_7872;
            Rectangle slotRect = new Rectangle(slotScreenX, slotScreenY, 16, 16);
            excludedAreas.add(slotRect);
        }
        this.renderSegmentedOverlay(context, screen.field_22789, screen.field_22790, excludedAreas);
        context.method_51448().method_22909();
    }

    private void renderSegmentedOverlay(class_332 context, int screenWidth, int screenHeight, Set<Rectangle> excludedAreas) {
        int alpha;
        int segmentSize = 3;
        float opacity = this.getOpacity();
        int overlayColor = alpha = (int)(opacity * 255.0f) << 24;
        for (int y = 0; y < screenHeight; y += segmentSize) {
            for (int x = 0; x < screenWidth; x += segmentSize) {
                int segmentEndY;
                int segmentEndX = Math.min(x + segmentSize, screenWidth);
                if (this.overlapsWithExcludedArea(x, y, segmentEndX - x, (segmentEndY = Math.min(y + segmentSize, screenHeight)) - y, excludedAreas)) continue;
                context.method_25294(x, y, segmentEndX, segmentEndY, overlayColor);
            }
        }
    }

    private boolean overlapsWithExcludedArea(int x, int y, int width, int height, Set<Rectangle> excludedAreas) {
        Rectangle segment = new Rectangle(x, y, width, height);
        for (Rectangle excluded : excludedAreas) {
            if (!segment.intersects(excluded)) continue;
            return true;
        }
        return false;
    }

    public boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.searchHudElement != null) {
            return this.searchHudElement.handleKeyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.searchHudElement != null) {
            return this.searchHudElement.handleMouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public void clearSearch() {
        if (this.searchHudElement != null) {
            this.searchHudElement.clearSearch();
            this.searchHudElement.setOverlayActive(false);
        }
        this.matchingSlots.clear();
        this.isSearching = false;
        this.lastSearchTerm = "";
        this.lastSlotContentHash = 0L;
    }

    public boolean isEnabled() {
        return FishyConfig.getState("invSearch", false);
    }

    public void setEnabled(boolean enabled) {
        FishyConfig.enable("invSearch", enabled);
        if (!enabled) {
            this.clearSearch();
        }
    }

    public void setSearchHudElement(SearchHudElement element) {
        this.searchHudElement = element;
    }

    private void ensureSearchHudElement() {
        if (this.searchHudElement == null) {
            for (HudElement element : ElementRegistry.getElements()) {
                SearchHudElement searchElement;
                if (!(element instanceof SearchHudElement)) continue;
                this.searchHudElement = searchElement = (SearchHudElement)element;
                break;
            }
        }
    }

    private long calculateSlotContentHash(class_465<?> screen) {
        long hash = 0L;
        for (class_1735 slot : screen.method_17577().field_7761) {
            class_1799 stack = slot.method_7677();
            if (stack != null && !stack.method_7960()) {
                hash = hash * 31L + (long)stack.method_7909().hashCode();
                hash = hash * 31L + (long)stack.method_7947();
                hash = hash * 31L + (long)stack.hashCode();
            }
            hash = hash * 31L + (long)slot.field_7874;
        }
        return hash;
    }

    public void forceRefresh() {
        this.lastSlotContentHash = 0L;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Rectangle {
        int x;
        int y;
        int width;
        int height;

        Rectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        boolean intersects(Rectangle other) {
            return this.x < other.x + other.width && this.x + this.width > other.x && this.y < other.y + other.height && this.y + this.height > other.y;
        }
    }
}

