/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.handler.TabScanner;
import me.valkeea.fishyaddons.util.SkyblockCheck;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class PetInfo {
    private static boolean isOn = false;
    private static boolean nextCheck = false;
    private static boolean dynamicCheck = false;
    private static boolean xpCheck = false;
    private static boolean tablistState = false;
    private static long lastCheckTime = 0L;
    private static boolean widget = false;
    private static boolean newPet = false;
    private static boolean pendingSummonScan = false;

    private PetInfo() {
    }

    public static void refresh() {
        isOn = FishyConfig.getState("petHud", false);
        dynamicCheck = FishyConfig.getState("tabTicks", false);
        xpCheck = FishyConfig.getState("petXpCheck", false);
    }

    public static void update() {
        PetInfo.setTablistReady(true);
        PetInfo.setNextCheck(true);
    }

    public static void confirm(boolean found) {
        newPet = found;
    }

    public static boolean getNextCheck() {
        boolean shouldCheck;
        long now = System.currentTimeMillis();
        boolean bl = shouldCheck = (dynamicCheck || nextCheck) && tablistState && widget && now - lastCheckTime >= 1000L;
        if (shouldCheck) {
            lastCheckTime = now;
            if (nextCheck && newPet) {
                nextCheck = false;
                newPet = false;
            }
        }
        return shouldCheck;
    }

    public static void handleChat(String message) {
        if (!isOn || !SkyblockCheck.getInstance().rules()) {
            return;
        }
        Pattern directPattern = Pattern.compile("\\[Lvl \\d+\\] ((?:[^\u00a7]|\u00a7.)+?)(?=\u00a7a\u00a7lVIEW RULE|$)");
        Matcher directMatcher = directPattern.matcher(message);
        if (directMatcher.find()) {
            String msg = directMatcher.group();
            msg = msg.replace("!", "");
            String stripped = class_124.method_539((String)msg);
            class_5250 petInfo = class_2561.method_43470((String)msg);
            TabScanner.setPet((class_2561)petInfo);
            class_5250 petOutline = class_2561.method_43470((String)stripped).method_27694(style -> style.method_10977(class_124.field_1074));
            TabScanner.setOutline((class_2561)petOutline);
            pendingSummonScan = false;
            PetInfo.setNextCheck(false);
            return;
        }
        Pattern summonPattern = Pattern.compile("You summoned your (.+) ?[!\u00a1]?");
        Matcher summonMatcher = summonPattern.matcher(message);
        if (summonMatcher.find() || message.matches("\\[Lvl \\d+\\] .+")) {
            TabScanner.clearPet();
            TabScanner.clearOutline();
            pendingSummonScan = true;
            PetInfo.setNextCheck(true);
            TabScanner.clearFailCount();
        }
        if (message.contains("You despawned your")) {
            class_5250 msg = class_2561.method_43470((String)"You despawned your pet").method_10862(class_2583.field_24360.method_36139(-8355712));
            TabScanner.setPet((class_2561)msg);
            pendingSummonScan = false;
            PetInfo.setNextCheck(false);
        }
    }

    public static void setNextCheck(boolean allow) {
        nextCheck = allow;
    }

    public static void setTablistReady(boolean ready) {
        tablistState = ready;
    }

    public static void setPending(boolean pending) {
        pendingSummonScan = pending;
    }

    public static void setWidget(boolean found) {
        widget = found;
    }

    public static boolean isPending() {
        return pendingSummonScan;
    }

    public static boolean widget() {
        return widget;
    }

    public static boolean isDynamic() {
        return dynamicCheck;
    }

    public static boolean isOn() {
        return isOn;
    }

    public static boolean shouldScanForXp() {
        return xpCheck;
    }
}

