/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.listener;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.handler.ChatAlert;
import me.valkeea.fishyaddons.handler.ChatTimers;
import me.valkeea.fishyaddons.handler.PetInfo;
import me.valkeea.fishyaddons.listener.WorldEvent;
import me.valkeea.fishyaddons.render.BeaconRenderer;
import me.valkeea.fishyaddons.tracker.TrackerUtils;
import me.valkeea.fishyaddons.util.AreaUtils;
import me.valkeea.fishyaddons.util.HelpUtil;
import me.valkeea.fishyaddons.util.SkyblockCheck;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class ClientChat {
    private static final ClientChat INSTANCE = new ClientChat();
    private static class_2338 beaconPos = null;

    private ClientChat() {
    }

    public static ClientChat getInstance() {
        return INSTANCE;
    }

    public static class_2338 getBeaconPos() {
        return beaconPos;
    }

    public static void setBeaconPos(class_2338 pos) {
        beaconPos = pos;
    }

    public static void init() {
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            String text = message.getString();
            ClientChat.handleGameplayMessages(text);
            ClientChat.handleCoordinates(text);
            TrackerUtils.checkForHoverEvents(message);
        });
        ClientReceiveMessageEvents.CHAT.register((message, signedMessage, sender, params, timestamp) -> {
            String text = message.getString();
            ClientChat.handleCoordinates(text);
        });
    }

    private static void handleGameplayMessages(String text) {
        INSTANCE.onClientChat(text);
        ChatAlert.handleMatch(text);
        PetInfo.handleChat(text);
        TrackerUtils.handleChat(text);
    }

    private static void handleCoordinates(String text) {
        Pattern coordPattern = Pattern.compile("\\bx\\s*:\\s*(-?\\d{1,7})\\s*,\\s*y\\s*:\\s*(-?\\d{1,7})\\s*,\\s*z\\s*:\\s*(-?\\d{1,7})\\b", 2);
        Matcher matcher = coordPattern.matcher(text);
        if (matcher.find()) {
            int x = Integer.parseInt(matcher.group(1));
            int y = Integer.parseInt(matcher.group(2));
            int z = Integer.parseInt(matcher.group(3));
            class_2338 newPos = new class_2338(x, y, z);
            String label = "";
            int endOfCoords = matcher.end();
            if (endOfCoords < text.length()) {
                label = HelpUtil.stripColor(text.substring(endOfCoords).trim());
            }
            if (!newPos.equals((Object)BeaconRenderer.getActualPos(new class_243((class_2382)newPos))) && FishyConfig.getState("renderCoords", false)) {
                BeaconRenderer.setBeacon(BeaconRenderer.getActualPos(new class_243((class_2382)newPos)), FishyConfig.getInt("renderCoordsColor"), label);
            }
        }
    }

    public void onClientChat(String message) {
        Pattern pattern = Pattern.compile("entered (MM )?The Catacombs");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            WorldEvent.getInstance().bypass();
            AreaUtils.setIsland("dungeon");
        }
        if (message.contains("Glacite Mineshafts")) {
            WorldEvent.getInstance().bypass();
            AreaUtils.setIsland("mineshaft");
        }
        if (message.contains("You are playing on profile:")) {
            SkyblockCheck.getInstance().setInSkyblock(true);
        }
        if (message.contains("You adjusted the frequency of the Beacon!")) {
            ChatTimers.getInstance().beaconStart();
        }
    }
}

