/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.safeguard;

import java.util.List;
import me.valkeea.fishyaddons.safeguard.BlacklistManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class BlacklistMatcher {
    private BlacklistMatcher() {
    }

    public static boolean isBlacklistedGUI(class_465<?> gui, String screenClassName) {
        String guiTitle = BlacklistMatcher.getGuiTitle(gui);
        if (guiTitle != null) {
            for (BlacklistManager.GuiBlacklistEntry entry : BlacklistMatcher.getMergedBlacklist()) {
                if (!entry.enabled || !entry.checkTitle) continue;
                for (String identifier : entry.identifiers) {
                    String cleanIdentifier = BlacklistMatcher.stripColor(identifier).toLowerCase().trim();
                    if (!guiTitle.equalsIgnoreCase(cleanIdentifier) && !guiTitle.toLowerCase().contains(cleanIdentifier)) continue;
                    return true;
                }
            }
        }
        for (class_1735 slot : gui.method_17577().field_7761) {
            class_1799 stack = slot.method_7677();
            if (stack == null || stack.method_7960() || !BlacklistMatcher.isBlacklistedItem(stack, screenClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklistedItem(class_1799 stack, String screenClassName) {
        List tooltip;
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_310 client = class_310.method_1551();
        try {
            tooltip = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)client.field_1724, (class_1836)class_1836.field_41070);
        }
        catch (Throwable t) {
            return false;
        }
        for (BlacklistManager.GuiBlacklistEntry entry : BlacklistMatcher.getMergedBlacklist()) {
            if (!entry.enabled) continue;
            for (String identifier : entry.identifiers) {
                String cleanName;
                String cleanIdentifier = BlacklistMatcher.stripColor(identifier).toLowerCase().trim();
                if (entry.checkTitle && screenClassName != null && screenClassName.toLowerCase().contains(cleanIdentifier)) {
                    return true;
                }
                if (stack.method_65130() != null && (cleanName = BlacklistMatcher.stripColor(stack.method_65130().getString()).toLowerCase().trim()).contains(cleanIdentifier)) {
                    return true;
                }
                for (class_2561 line : tooltip) {
                    String cleanLine = BlacklistMatcher.stripColor(line.getString()).toLowerCase().trim();
                    if (!cleanLine.contains(cleanIdentifier)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getGuiTitle(class_465<?> gui) {
        try {
            return gui.method_25440().getString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String stripColor(String input) {
        return input == null ? null : input.replaceAll("(?i)\u00a7[0-9a-fklmnor]", "");
    }

    public static List<BlacklistManager.GuiBlacklistEntry> getMergedBlacklist() {
        return BlacklistManager.getMergedBlacklist();
    }
}

