/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.tracker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

@Environment(value=EnvType.CLIENT)
public class InventoryTracker {
    private static final int STACK_INCREASE_THRESHOLD = 64;
    private static final Map<Long, Integer> recentEnchantedBookDrops = new ConcurrentHashMap<Long, Integer>();
    private static final long DROP_CORRELATION_WINDOW = 5000L;
    private static boolean monitoringEnabled = false;
    private static long monitoringStartTime = 0L;
    private static final long MONITORING_WINDOW = 60000L;
    private static boolean lsEnabled = false;
    private static long lsStartTime = 0L;
    private static final long LS_WINDOW = 10000L;
    private static final Map<String, String> TRACKED_PLAYER_HEADS = new ConcurrentHashMap<String, String>();
    private static final Map<Long, String> recentTrackedItemDrops;
    private static final Map<String, Integer> lastKnownStackSizes;

    private InventoryTracker() {
    }

    public static void onEnchantedBookDropDetected(int quantity) {
        long currentTime = System.currentTimeMillis();
        recentEnchantedBookDrops.put(currentTime, quantity);
        recentEnchantedBookDrops.entrySet().removeIf(entry -> currentTime - (Long)entry.getKey() > 10000L);
    }

    public static void onItemAdded(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        if (!recentEnchantedBookDrops.isEmpty()) {
            InventoryTracker.handleEnchantedBookAdded(stack);
        }
        if (!InventoryTracker.isMonitoringActive()) {
            return;
        }
        if (stack.method_7909() == class_1802.field_8598) {
            InventoryTracker.handleEnchantedBookAdded(stack);
        } else if (stack.method_7909() == class_1802.field_8575) {
            InventoryTracker.handlePlayerHeadAdded(stack);
        }
    }

    private static boolean isMonitoringActive() {
        if (!monitoringEnabled) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - monitoringStartTime > 60000L) {
            monitoringEnabled = false;
            return false;
        }
        return true;
    }

    public static boolean isLsMonitoringActive() {
        if (!lsEnabled) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lsStartTime > 10000L) {
            lsEnabled = false;
            return false;
        }
        return true;
    }

    private static void handleEnchantedBookAdded(class_1799 stack) {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<Long, Integer> entry : recentEnchantedBookDrops.entrySet()) {
            long dropTime = entry.getKey();
            int dropQuantity = entry.getValue();
            if (currentTime - dropTime > 5000L || dropQuantity < stack.method_7947()) continue;
            recentEnchantedBookDrops.remove(dropTime);
            ItemTrackerData.removeGenericEnchantedBook(stack.method_7947());
            return;
        }
    }

    private static void handlePlayerHeadAdded(class_1799 stack) {
        int previousStackSize;
        String displayName = stack.method_7964().getString().toLowerCase().trim();
        String cleanDisplayName = displayName.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        String bazaarId = TRACKED_PLAYER_HEADS.get(cleanDisplayName);
        if (bazaarId == null) {
            return;
        }
        int currentStackSize = stack.method_7947();
        if (currentStackSize > (previousStackSize = lastKnownStackSizes.getOrDefault(cleanDisplayName, 0).intValue())) {
            int rawIncrease = currentStackSize - previousStackSize;
            int newItems = rawIncrease > 64 ? 1 : rawIncrease;
            lastKnownStackSizes.put(cleanDisplayName, currentStackSize);
            ItemTrackerData.addDrop(cleanDisplayName, newItems);
        } else {
            lastKnownStackSizes.put(cleanDisplayName, currentStackSize);
        }
    }

    public static void cleanup() {
        long currentTime = System.currentTimeMillis();
        recentEnchantedBookDrops.entrySet().removeIf(entry -> currentTime - (Long)entry.getKey() > 15000L);
        recentTrackedItemDrops.entrySet().removeIf(entry -> currentTime - (Long)entry.getKey() > 15000L);
        if (lastKnownStackSizes.size() > 63) {
            lastKnownStackSizes.clear();
        }
    }

    public static void onLsDetected() {
        lsEnabled = true;
        lsStartTime = System.currentTimeMillis();
    }

    public static void onValuableEntityDamaged() {
        monitoringEnabled = true;
        monitoringStartTime = System.currentTimeMillis();
    }

    public static void onValuableEntityDamaged(String displayName) {
        if (displayName == null) {
            return;
        }
        if (!InventoryTracker.isEntityValuable(displayName)) {
            return;
        }
        monitoringEnabled = true;
        monitoringStartTime = System.currentTimeMillis();
    }

    private static boolean isEntityValuable(String displayName) {
        if (displayName == null) {
            return false;
        }
        String nameToCheck = displayName.toLowerCase();
        if (nameToCheck.matches(".*\\b(sea walker|guardian defender|sea witch|squid|loch emperor|the rider of the deep)\\b.*")) {
            return true;
        }
        return nameToCheck.matches(".*\\b(great white shark|tiger shark)\\b.*");
    }

    public static void onValuableEntityDeath(String entityName) {
        monitoringEnabled = true;
        monitoringStartTime = System.currentTimeMillis();
        Thread.startVirtualThread(() -> {
            try {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() - monitoringStartTime >= 1000L) {
                    monitoringEnabled = false;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    static {
        TRACKED_PLAYER_HEADS.put("emperor's skull", "DIVER_FRAGMENT");
        TRACKED_PLAYER_HEADS.put("great white shark tooth", "GREAT_WHITE_SHARK_TOOTH");
        recentTrackedItemDrops = new ConcurrentHashMap<Long, String>();
        lastKnownStackSizes = new ConcurrentHashMap<String, Integer>();
    }
}

