/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class KeyUtil {
    private static final Map<Integer, String> GLFW_KEY_NAMES = new HashMap<Integer, String>();

    private KeyUtil() {
    }

    public static String getDisplayNameFor(String key) {
        if (key == null) {
            return "";
        }
        if (key.startsWith("GLFW_KEY_KP_")) {
            return key.replace("GLFW_KEY_KP_", "Numpad ");
        }
        if (key.startsWith("GLFW_KEY_")) {
            String name = key.substring("GLFW_KEY_".length()).replace('_', ' ');
            if (name.startsWith("WORLD_")) {
                return "Intl " + name.substring(6);
            }
            return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
        }
        if (key.startsWith("MOUSE")) {
            try {
                int btn = Integer.parseInt(key.substring(5));
                return "Mouse " + (btn + 1);
            }
            catch (Exception exception) {
                return key;
            }
        }
        return key.substring(0, 1).toUpperCase() + key.substring(1).toLowerCase();
    }

    public static int getKeyCodeFromString(String key) {
        try {
            return (Integer)GLFW.class.getField(key).get(null);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String getGlfwKeyName(int keyCode) {
        return GLFW_KEY_NAMES.getOrDefault(keyCode, null);
    }

    static {
        GLFW_KEY_NAMES.put(65, "GLFW_KEY_A");
        GLFW_KEY_NAMES.put(66, "GLFW_KEY_B");
        for (Field field : GLFW.class.getFields()) {
            if (field.getType() != Integer.TYPE || !field.getName().startsWith("GLFW_KEY_")) continue;
            try {
                GLFW_KEY_NAMES.put(field.getInt(null), field.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

