/*
 * Decompiled with CFR 0.152.
 */
package crying_obsidian_update.item;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;

public abstract class TapochkiItem
extends ArmorItem {
    public TapochkiItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 5;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{2, 0, 0, 0})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 18;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("block.anvil.hit"));
            }

            public Ingredient getRepairIngredient() {
                return CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("minecraft:planks"))), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.COBBLESTONE)})});
            }

            public String getName() {
                return "tapochki";
            }

            public float getToughness() {
                return 0.4f;
            }

            public float getKnockbackResistance() {
                return 0.1f;
            }
        }, type, properties);
    }

    public static class Boots
    extends TapochkiItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "simplification_kiberwen_mod:textures/models/armor/tap_layer_1.png";
        }
    }
}

