/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.math;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.compat.Vector4f;
import nx.pingwheel.common.math.ScreenPos;

public class MathUtils {
    private MathUtils() {
    }

    public static ScreenPos worldToScreen(Vec3 worldPos, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        Window window = CommonClient.Game.m_91268_();
        Camera camera = CommonClient.Game.f_91063_.m_109153_();
        Vector4f worldPosRel = new Vector4f(camera.m_90583_().m_82548_().m_82549_(worldPos), 1.0f);
        worldPosRel.mul(modelViewMatrix);
        worldPosRel.mul(projectionMatrix);
        float depth = worldPosRel.w;
        if (depth != 0.0f) {
            worldPosRel.div(depth);
        }
        return new ScreenPos((float)window.m_85445_() * (0.5f + worldPosRel.x * 0.5f), (float)window.m_85446_() * (0.5f - worldPosRel.y * 0.5f), depth);
    }

    public static void rotateZ(PoseStack matrixStack, float theta) {
        matrixStack.m_85845_(Vector3f.f_122227_.m_122270_(theta));
    }

    public static Vec2 calculateAngleRectIntersection(float angle, Vec2 leftTop, Vec2 rightBottom) {
        Vec3 direction = new Vec3(Math.cos(angle), Math.sin(angle), 0.0);
        float width = rightBottom.f_82470_ - leftTop.f_82470_;
        float height = rightBottom.f_82471_ - leftTop.f_82471_;
        direction = direction.m_82559_(new Vec3((double)(1.0f / width), (double)(1.0f / height), 0.0));
        double dx = Math.cos(angle);
        double dy = Math.sin(angle);
        float cx = width * 0.5f;
        float cy = height * 0.5f;
        if (Math.abs(direction.f_82479_) < Math.abs(direction.f_82480_)) {
            if (direction.f_82480_ < 0.0) {
                double t = (double)(-cy) / dy;
                double x = (double)cx + t * dx;
                return new Vec2((float)x + leftTop.f_82470_, leftTop.f_82471_);
            }
            double t = (double)cy / dy;
            double x = (double)cx + t * dx;
            return new Vec2((float)x + leftTop.f_82470_, rightBottom.f_82471_);
        }
        if (direction.f_82479_ < 0.0) {
            double t = (double)(-cx) / dx;
            double y = (double)cy + t * dy;
            return new Vec2(leftTop.f_82470_, (float)y + leftTop.f_82471_);
        }
        double t = (double)cx / dx;
        double y = (double)cy + t * dy;
        return new Vec2(rightBottom.f_82470_, (float)y + leftTop.f_82471_);
    }
}

