/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.network;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.network.IPacket;
import nx.pingwheel.common.network.PacketHandler;

public record PingLocationC2SPacket(String channel, Vec3 pos, UUID entity, int sequence, int dimension) implements IPacket
{
    public static final ResourceLocation PACKET_ID = new ResourceLocation("ping-wheel-c2s", "ping-location");

    public PingLocationC2SPacket() {
        this(null, null, null, 0, 0);
    }

    public PingLocationC2SPacket(FriendlyByteBuf buf) {
        this(buf.m_130136_(128), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readBoolean() ? buf.m_130259_() : null, buf.readInt(), buf.readInt());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130072_(this.channel, 128);
        buf.writeDouble(this.pos.f_82479_);
        buf.writeDouble(this.pos.f_82480_);
        buf.writeDouble(this.pos.f_82481_);
        buf.writeBoolean(this.entity != null);
        if (this.entity != null) {
            buf.m_130077_(this.entity);
        }
        buf.writeInt(this.sequence);
        buf.writeInt(this.dimension);
    }

    @Override
    public boolean isCorrupt() {
        return this.channel == null;
    }

    @Override
    public ResourceLocation getId() {
        return PACKET_ID;
    }

    public static PingLocationC2SPacket readSafe(FriendlyByteBuf buf) {
        return PacketHandler.readSafe(buf, PingLocationC2SPacket.class);
    }
}

