/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.PlayerInfoMode;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.render.DrawContext;
import nx.pingwheel.common.resource.LanguageUtils;

public class PingLocationRenderer {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static final int WHITE = -1;

    private PingLocationRenderer() {
    }

    public static void draw(DrawContext ctx, PingView ping) {
        boolean showVerbosePlayerInfo;
        ScreenPos screenPos = ping.getScreenPos();
        if (screenPos == null) {
            return;
        }
        PoseStack m = ctx.getMatrices();
        float pingScale = ping.getScale();
        m.m_85836_();
        m.m_85837_((double)screenPos.x, (double)screenPos.y, 0.0);
        m.m_85841_(pingScale, pingScale, 1.0f);
        boolean labelUseTeamColor = CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.FULL || CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.LABELS_ONLY;
        boolean pingUseTeamColor = CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.FULL || CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.PING_ONLY;
        int distanceColor = labelUseTeamColor ? ping.getTeamColor() : -1;
        int pingColor = pingUseTeamColor ? ping.getTeamColor() : -1;
        PlayerInfo author = ping.getPlayerInfo();
        PlayerInfo compactPlayerInfo = CLIENT_CONFIG.getPlayerInfoMode() == PlayerInfoMode.COMPACT ? author : null;
        MutableComponent distanceText = LanguageUtils.UNIT_METERS.get("%,.1f".formatted(ping.getDistance()));
        ctx.renderLabel((Component)distanceText, -1.5f, compactPlayerInfo, distanceColor);
        ctx.renderPing(ping.getItemStack(), CLIENT_CONFIG.isItemIconVisible(), pingColor);
        boolean isPlayerListHeld = CLIENT_CONFIG.getPlayerInfoMode() == PlayerInfoMode.HOLD && CommonClient.Game.f_91066_.f_92099_.m_90857_();
        boolean bl = showVerbosePlayerInfo = CLIENT_CONFIG.getPlayerInfoMode() == PlayerInfoMode.ALWAYS || isPlayerListHeld;
        if (showVerbosePlayerInfo && author != null) {
            MutableComponent displayName = PlayerTeam.m_83348_((Team)author.m_105340_(), (Component)Component.m_237113_((String)author.m_105312_().getName()));
            if (!labelUseTeamColor) {
                displayName = displayName.m_130940_(ChatFormatting.RESET);
            }
            ctx.renderLabel((Component)displayName, 1.75f, author, -1);
        }
        m.m_85849_();
    }
}

