/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.forge;

import com.mojang.brigadier.context.CommandContext;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import nx.pingwheel.common.CommonServer;
import nx.pingwheel.common.command.ServerCommandBuilder;
import nx.pingwheel.common.network.PingLocationC2SPacket;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.network.UpdateChannelC2SPacket;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.forge.ForgeClient;
import nx.pingwheel.forge.platform.PlatformNetworkServiceImpl;
import org.apache.logging.log4j.util.TriConsumer;

@Mod(value="pingwheel")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeMain {
    private static final String PROTOCOL_VERSION = "1";
    public static final EventNetworkChannel PING_LOCATION_CHANNEL_C2S = NetworkRegistry.newEventChannel((ResourceLocation)PingLocationC2SPacket.PACKET_ID, () -> "1", c -> true, s -> true);
    public static final EventNetworkChannel PING_LOCATION_CHANNEL_S2C = NetworkRegistry.newEventChannel((ResourceLocation)PingLocationS2CPacket.PACKET_ID, () -> "1", c -> true, s -> true);
    public static final EventNetworkChannel UPDATE_CHANNEL_C2S = NetworkRegistry.newEventChannel((ResourceLocation)UpdateChannelC2SPacket.PACKET_ID, () -> "1", c -> true, s -> true);

    public ForgeMain() {
        CommonServer.INSTANCE.onInit();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ForgeClient::new);
        PlatformNetworkServiceImpl.CHANNEL_MAP.put(PingLocationC2SPacket.PACKET_ID, PING_LOCATION_CHANNEL_C2S);
        PlatformNetworkServiceImpl.CHANNEL_MAP.put(PingLocationS2CPacket.PACKET_ID, PING_LOCATION_CHANNEL_S2C);
        PlatformNetworkServiceImpl.CHANNEL_MAP.put(UpdateChannelC2SPacket.PACKET_ID, UPDATE_CHANNEL_C2S);
        ForgeMain.registerPacketHandler(PING_LOCATION_CHANNEL_C2S, PingLocationC2SPacket::readSafe, CommonServer.INSTANCE::onPingLocationPacket);
        ForgeMain.registerPacketHandler(UPDATE_CHANNEL_C2S, UpdateChannelC2SPacket::readSafe, CommonServer.INSTANCE::onChannelUpdatePacket);
    }

    public static <T> void registerPacketHandler(EventNetworkChannel channel, Function<FriendlyByteBuf, T> packetReader, TriConsumer<MinecraftServer, ServerPlayer, T> packetHandler) {
        channel.addListener(event -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            FriendlyByteBuf payload = event.getPayload();
            ServerPlayer sender = ctx.getSender();
            if (payload != null && sender != null) {
                Object packet = packetReader.apply(payload);
                ctx.enqueueWork(() -> packetHandler.accept((Object)sender.m_20194_(), (Object)sender, packet));
            }
            ctx.setPacketHandled(true);
        });
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(ServerCommandBuilder.build((TriConsumer<CommandContext<CommandSourceStack>, Boolean, MutableComponent>)((TriConsumer)(context, success, response) -> {
            if (success.booleanValue()) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)LanguageUtils.withModPrefix(response), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)LanguageUtils.withModPrefix(response));
            }
        })));
    }
}

