/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.forge.platform;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nx.pingwheel.common.platform.IPlatformClientEventService;
import nx.pingwheel.common.render.WorldRenderContext;

public class PlatformClientEventServiceImpl
implements IPlatformClientEventService {
    @Override
    public void registerTickStartEvent(Runnable callback) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickEventEventHandler(callback));
    }

    @Override
    public void registerJoinServerEvent(Runnable callback) {
        MinecraftForge.EVENT_BUS.register((Object)new JoinServerEventHandler(callback));
    }

    @Override
    public void registerLeaveServerEvent(Runnable callback) {
        MinecraftForge.EVENT_BUS.register((Object)new LeaveServerEventHandler(callback));
    }

    @Override
    public void registerRenderWorldEvent(Consumer<WorldRenderContext> callback) {
        MinecraftForge.EVENT_BUS.register((Object)new RenderWorldEventEventHandler(callback));
    }

    @Override
    public void registerRenderGUIEvent(BiConsumer<PoseStack, Float> callback) {
        MinecraftForge.EVENT_BUS.register((Object)new RenderGUIEventEventHandler(callback));
    }

    private record ClientTickEventEventHandler(Runnable callback) {
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase.equals((Object)TickEvent.Phase.START)) {
                this.callback.run();
            }
        }
    }

    private record JoinServerEventHandler(Runnable callback) {
        @SubscribeEvent
        public void onClientConnectedToServer(ClientPlayerNetworkEvent.LoggingIn event) {
            this.callback.run();
        }
    }

    private record LeaveServerEventHandler(Runnable callback) {
        @SubscribeEvent
        public void onClientDisconnectedFromServer(ClientPlayerNetworkEvent.LoggingOut event) {
            this.callback.run();
        }
    }

    private record RenderWorldEventEventHandler(Consumer<WorldRenderContext> callback) {
        @SubscribeEvent
        public void onRenderWorld(RenderLevelStageEvent event) {
            if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_WEATHER)) {
                this.callback.accept(WorldRenderContext.of(event.getPoseStack().m_85850_().m_85861_(), event.getProjectionMatrix(), Float.valueOf(event.getPartialTick()), event.getCamera()));
            }
        }
    }

    private record RenderGUIEventEventHandler(BiConsumer<PoseStack, Float> callback) {
        @SubscribeEvent
        public void onPreGuiRender(RenderGuiOverlayEvent.Pre event) {
            if (event.getOverlay() == VanillaGuiOverlay.VIGNETTE.type()) {
                this.callback.accept(event.getPoseStack(), Float.valueOf(event.getPartialTick()));
            }
        }
    }
}

