/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.helper.MathUtils;
import nx.pingwheel.common.resource.ResourceReloadListener;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class DrawContext {
    private static final int WHITE = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    private static final int SHADOW_BLACK = FastColor.ARGB32.m_13660_((int)64, (int)0, (int)0, (int)0);
    private static final int LIGHT_VALUE_MAX = 0xF000F0;
    private PoseStack matrices;

    public DrawContext(PoseStack matrices) {
        this.matrices = matrices;
    }

    public void renderLabel(Component text, float yOffset, PlayerInfo player) {
        float extraWidth = player != null ? 10.0f : 0.0f;
        float f = (float)ClientGlobal.Game.f_91062_.m_92852_((FormattedText)text) + extraWidth;
        Objects.requireNonNull(ClientGlobal.Game.f_91062_);
        Vec2 textMetrics = new Vec2(f, 9.0f);
        Vec2 textOffset = textMetrics.m_165903_(-0.5f).m_165910_(new Vec2(0.0f, textMetrics.f_82471_ * yOffset));
        this.matrices.m_85836_();
        this.matrices.m_252880_(textOffset.f_82470_, textOffset.f_82471_, 0.0f);
        GuiComponent.m_93172_((PoseStack)this.matrices, (int)-2, (int)-2, (int)((int)textMetrics.f_82470_ + 1), (int)((int)textMetrics.f_82471_), (int)SHADOW_BLACK);
        ClientGlobal.Game.f_91062_.m_92889_(this.matrices, text, extraWidth, 0.0f, WHITE);
        if (player != null) {
            this.matrices.m_85837_(-0.5, -0.5, 0.0);
            this.renderPlayerHead(player);
        }
        this.matrices.m_85849_();
    }

    public void renderPlayerHead(PlayerInfo player) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)player.m_105337_());
        RenderSystem.m_69478_();
        GuiComponent.m_93143_((PoseStack)this.matrices, (int)0, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        GuiComponent.m_93143_((PoseStack)this.matrices, (int)0, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.m_69461_();
    }

    public void renderPing(ItemStack itemStack, boolean drawItemIcon) {
        if (itemStack != null && drawItemIcon) {
            this.renderGuiItemModel(itemStack);
        } else if (ResourceReloadListener.hasCustomTexture()) {
            this.renderCustomPingIcon();
        } else {
            this.renderDefaultPingIcon();
        }
    }

    public void renderGuiItemModel(ItemStack itemStack) {
        boolean bl;
        BakedModel model = ClientGlobal.Game.m_91291_().m_174264_(itemStack, null, null, 0);
        ClientGlobal.Game.m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = RenderSystem.m_157191_();
        matrixStack.m_85836_();
        matrixStack.m_252931_(this.matrices.m_85850_().m_252922_());
        matrixStack.m_252880_(0.0f, 0.0f, -0.5f);
        matrixStack.m_85841_(16.0f, -16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource immediate = ClientGlobal.Game.m_91269_().m_110104_();
        boolean bl2 = bl = !model.m_7547_();
        if (bl) {
            Lighting.m_84930_();
        }
        PoseStack matrixStackDummy = new PoseStack();
        ClientGlobal.Game.m_91291_().m_115143_(itemStack, ItemDisplayContext.GUI, false, matrixStackDummy, (MultiBufferSource)immediate, 0xF000F0, OverlayTexture.f_118083_, model);
        immediate.m_109911_();
        RenderSystem.m_69482_();
        if (bl) {
            Lighting.m_84931_();
        }
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public void renderCustomPingIcon() {
        int size = 12;
        int offset = -6;
        RenderSystem.m_157456_((int)0, (ResourceLocation)ClientGlobal.PING_TEXTURE_ID);
        RenderSystem.m_69478_();
        GuiComponent.m_93143_((PoseStack)this.matrices, (int)-6, (int)-6, (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (int)12, (int)12);
        RenderSystem.m_69461_();
    }

    public void renderDefaultPingIcon() {
        this.matrices.m_85836_();
        MathUtils.rotateZ(this.matrices, 0.7853982f);
        this.matrices.m_85837_(-2.5, -2.5, 0.0);
        GuiComponent.m_93172_((PoseStack)this.matrices, (int)0, (int)0, (int)5, (int)5, (int)WHITE);
        this.matrices.m_85849_();
    }

    public void renderArrow(boolean antialias) {
        if (antialias) {
            GL11.glEnable((int)2881);
        }
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f mat = this.matrices.m_85850_().m_252922_();
        bufferBuilder.m_252986_(mat, 5.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(mat, -5.0f, -5.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(mat, -3.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(mat, -5.0f, 5.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69461_();
        GL11.glDisable((int)2881);
    }
}

