/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.forge;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.commands.ClientCommandBuilder;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.ConfigHandler;
import nx.pingwheel.common.core.ClientCore;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.networking.PingLocationS2CPacket;
import nx.pingwheel.common.networking.UpdateChannelC2SPacket;
import nx.pingwheel.common.resource.ResourceReloadListener;
import nx.pingwheel.common.screen.SettingsScreen;
import nx.pingwheel.forge.Main;

@OnlyIn(value=Dist.CLIENT)
public class Client {
    public Client() {
        ClientGlobal.ConfigHandler = new ConfigHandler<ClientConfig>(ClientConfig.class, FMLPaths.CONFIGDIR.get().resolve("ping-wheel.json"));
        ClientGlobal.ConfigHandler.load();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerNetworkPackets();
        this.registerReloadListener();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeyBindings);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> new SettingsScreen((Screen)parent)));
    }

    private void registerNetworkPackets() {
        Main.PING_LOCATION_CHANNEL_S2C.addListener(event -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            FriendlyByteBuf payload = event.getPayload();
            if (payload != null) {
                PingLocationS2CPacket packet = PingLocationS2CPacket.readSafe(payload);
                ctx.enqueueWork(() -> ClientCore.onPingLocation(packet));
            }
            ctx.setPacketHandled(true);
        });
    }

    private void registerReloadListener() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(event -> event.registerReloadListener((PreparableReloadListener)new ResourceReloadListener()));
    }

    private void onRegisterKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(ClientGlobal.KEY_BINDING_PING);
        event.register(ClientGlobal.KEY_BINDING_SETTINGS);
        event.register(ClientGlobal.KEY_BINDING_NAME_LABELS);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            ClientCore.onTick();
        }
    }

    @SubscribeEvent
    public void onClientConnectedToServer(ClientPlayerNetworkEvent.LoggingIn event) {
        Global.NetHandler.sendToServer(new UpdateChannelC2SPacket(ClientGlobal.ConfigHandler.getConfig().getChannel()));
    }

    @SubscribeEvent
    public void onClientDisconnectedFromServer(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientCore.onDisconnect();
    }

    @SubscribeEvent
    public void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_WEATHER)) {
            ClientCore.onRenderWorld(event.getPoseStack().m_85850_().m_252922_(), event.getProjectionMatrix(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public void onPreGuiRender(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.VIGNETTE.type()) {
            ClientCore.onRenderGUI(event.getPoseStack(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register(ClientCommandBuilder.build((context, success, response) -> {
            if (success.booleanValue()) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)LanguageUtils.withModPrefix(response), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)LanguageUtils.withModPrefix(response));
            }
        }));
    }
}

