/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.screen;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_316;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_353;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5499;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.compat.Component;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.PlayerInfoMode;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.integration.TeamContext;
import nx.pingwheel.common.integration.TeamContextHandler;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.screen.OptionUtils;

public class SettingsScreen
extends class_437 {
    private static final int WHITE = 0xFFFFFF;
    private static final int GRAY = 0xA0A0A0;
    private static final int LINE_LENGTH = 170;
    private final ClientConfig config = ClientConfig.HANDLER.getConfig();
    private class_437 parent;
    private class_353 list;
    private class_342 channelTextField;

    public SettingsScreen() {
        super((class_2561)LanguageUtils.settings("title").get(new Object[0]));
    }

    public SettingsScreen(class_437 parent) {
        this();
        this.parent = parent;
    }

    public void method_25393() {
        this.channelTextField.method_1865();
    }

    protected void method_25426() {
        this.list = new class_353(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.list.method_20407(this.getPingVolumeOption(), this.getPingDurationOption());
        this.list.method_20407(this.getPingDistanceOption(), this.getCorrectionPeriodOption());
        this.list.method_20407(this.getItemIconsVisibleOption(), this.getDirectionIndicatorVisibleOption());
        this.list.method_20407(this.getPlayerInfoModeOption(), this.getTeamColorModeOption());
        this.list.method_20407(this.getPingSizeOption(), null);
        int yOffset = 50 + 25 * this.list.method_25396().size();
        this.channelTextField = new class_342(this.field_22793, this.field_22789 / 2 - 100, yOffset, 200, 20, (class_2561)Component.empty());
        this.channelTextField.method_1880(128);
        this.channelTextField.method_1852(this.config.getChannel());
        this.channelTextField.method_1863(this.config::setChannel);
        this.method_25429((class_364)this.channelTextField);
        this.method_25429((class_364)this.list);
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 27, 200, 20, class_5244.field_24334, button -> this.method_25419()));
    }

    public void method_25419() {
        ClientConfig.HANDLER.save();
        if (this.parent != null && this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        } else {
            super.method_25419();
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.list.method_25394(matrices, mouseX, mouseY, delta);
        SettingsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)20, (int)0xFFFFFF);
        SettingsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)LanguageUtils.settings("channel").get(new Object[0]), (int)(this.field_22789 / 2 - 100), (int)(this.channelTextField.field_22761 - 12), (int)0xA0A0A0);
        this.channelTextField.method_25394(matrices, mouseX, mouseY, delta);
        if (this.channelTextField.method_1882().isEmpty()) {
            SettingsScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.getChannelPlaceholder(), (int)(this.field_22789 / 2 - 100 + 4), (int)(this.channelTextField.field_22761 + 6), (int)0xFFFFFF);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        List tooltipLines = SettingsScreen.getHoveredButtonTooltip(this.list, mouseX, mouseY);
        if (tooltipLines.isEmpty() && this.channelTextField.method_25367() && !this.channelTextField.method_25370()) {
            tooltipLines = this.field_22793.method_1728((class_5348)LanguageUtils.settings("channel.tooltip").get(new Object[0]), 170);
        }
        this.method_25417(matrices, tooltipLines, mouseX, mouseY);
    }

    private static List<class_5481> getHoveredButtonTooltip(class_353 buttonList, int mouseX, int mouseY) {
        class_5499 orderableTooltip = buttonList.method_29624((double)mouseX, (double)mouseY).orElse(null);
        if (orderableTooltip != null) {
            return orderableTooltip.method_31047();
        }
        return Collections.emptyList();
    }

    private class_5250 getChannelPlaceholder() {
        if (CommonClient.Game.field_1724 == null) {
            return Component.empty();
        }
        TeamContext teamContext = TeamContextHandler.getSelfContext();
        class_5250 placeholder = teamContext == TeamContext.NONE ? LanguageUtils.of("value", "global").get(new Object[0]) : LanguageUtils.settings("channel").path("placeholder").get(LanguageUtils.of("value", teamContext.toString()).get(new Object[0]));
        return placeholder.method_27692(class_124.field_1056).method_27692(class_124.field_1063);
    }

    private class_316 getPingVolumeOption() {
        LanguageUtils text = LanguageUtils.settings("ping_volume");
        return OptionUtils.ofInt(text.getKey(), 0, 100, 1, value -> {
            if (value == 0) {
                return text.get(class_5244.field_24333);
            }
            return text.get(LanguageUtils.UNIT_PERCENT.get(value));
        }, this.config::getPingVolume, this.config::setPingVolume);
    }

    private class_316 getPingDurationOption() {
        LanguageUtils text = LanguageUtils.settings("ping_duration");
        return OptionUtils.ofInt(text.getKey(), 1, 60, 1, value -> {
            if (value >= 60) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get(value));
        }, this.config::getPingDuration, this.config::setPingDuration);
    }

    private class_316 getPingDistanceOption() {
        LanguageUtils text = LanguageUtils.settings("ping_distance");
        return OptionUtils.ofInt(text.getKey(), 0, 2048, 16, value -> {
            if (value == 0) {
                return text.get(LanguageUtils.VALUE_HIDDEN);
            }
            if (value >= 2048) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_METERS.get(value));
        }, this.config::getPingDistance, this.config::setPingDistance);
    }

    private class_316 getCorrectionPeriodOption() {
        LanguageUtils text = LanguageUtils.settings("correction_period");
        return OptionUtils.ofFloat(text.getKey(), 0.1f, 5.0f, 0.1f, value -> {
            if (value.floatValue() >= 5.0f) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get("%.1f".formatted(value)));
        }, this.config::getCorrectionPeriod, this.config::setCorrectionPeriod);
    }

    private class_316 getItemIconsVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("item_icon_visible").getKey(), this.config::isItemIconVisible, this.config::setItemIconVisible);
    }

    private class_316 getDirectionIndicatorVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("direction_indicator_visible").getKey(), this.config::isDirectionIndicatorVisible, this.config::setDirectionIndicatorVisible);
    }

    private class_316 getPlayerInfoModeOption() {
        return OptionUtils.ofEnum(LanguageUtils.settings("player_info_mode").getKey(), PlayerInfoMode.class, mode -> LanguageUtils.of("value", mode.toString()).get(new Object[0]), mode -> {
            if (mode != PlayerInfoMode.HOLD) {
                return ImmutableList.of();
            }
            class_5250 kayPlayerListTitle = Component.translatable(CommonClient.Game.field_1690.field_1907.method_1431(), new Object[0]);
            class_2561 kayPlayerListName = CommonClient.Game.field_1690.field_1907.method_16007();
            return this.field_22793.method_1728((class_5348)LanguageUtils.settings("player_info_mode").path("hold", "tooltip").get(kayPlayerListTitle, kayPlayerListName), 170);
        }, this.config::getPlayerInfoMode, this.config::setPlayerInfoMode);
    }

    private class_316 getTeamColorModeOption() {
        return OptionUtils.ofEnum(LanguageUtils.settings("team_color_mode").getKey(), TeamColorMode.class, mode -> LanguageUtils.of("value", mode.toString()).get(new Object[0]), mode -> ImmutableList.of(), this.config::getTeamColorMode, this.config::setTeamColorMode);
    }

    private class_316 getPingSizeOption() {
        LanguageUtils text = LanguageUtils.settings("ping_size");
        return OptionUtils.ofInt(text.getKey(), 40, 300, 10, value -> text.get(LanguageUtils.UNIT_PERCENT.get(value)), this.config::getPingSize, this.config::setPingSize);
    }
}

