/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.integration;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import nx.pingwheel.common.integration.ModContext;

public class FTBTeamsWrapper {
    private FTBTeamsWrapper() {
    }

    public static Optional<UUID> getTeamId(Player player) {
        if (!ModContext.HasFTBTeams || !FTBTeamsAPI.api().isManagerLoaded()) {
            return Optional.empty();
        }
        TeamManager teamManager = FTBTeamsAPI.api().getManager();
        Team ftbTeam = teamManager.getTeamForPlayerID(player.getUUID()).orElse(null);
        if (ftbTeam == null || ftbTeam.isPlayerTeam()) {
            return Optional.empty();
        }
        return Optional.of(ftbTeam.getId());
    }

    public static Optional<UUID> getSelfTeamId() {
        if (!ModContext.HasFTBTeams || !FTBTeamsAPI.api().isClientManagerLoaded()) {
            return Optional.empty();
        }
        ClientTeamManager teamManager = FTBTeamsAPI.api().getClientManager();
        Team ftbTeam = teamManager.selfTeam();
        if (ftbTeam == null || ftbTeam.isPlayerTeam()) {
            return Optional.empty();
        }
        return Optional.of(ftbTeam.getId());
    }
}

