/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.screen;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.PlayerInfoMode;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.integration.TeamContext;
import nx.pingwheel.common.integration.TeamContextHandler;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.screen.OptionUtils;

public class SettingsScreen
extends OptionsSubScreen {
    private static final int WHITE = -1;
    private static final int GRAY = -6250336;
    private final ClientConfig config = ClientConfig.HANDLER.getConfig();
    private Screen parent;
    private EditBox channelTextField;

    public SettingsScreen() {
        super(null, null, (Component)LanguageUtils.settings("title").get(new Object[0]));
    }

    public SettingsScreen(Screen parent) {
        this();
        this.parent = parent;
    }

    public void tick() {
        if (this.channelTextField.isFocused() && this.getFocused() != this.channelTextField) {
            this.setFocused((GuiEventListener)this.channelTextField);
        }
    }

    protected void init() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addContents() {
        this.list = (OptionsList)this.layout.addToContents((LayoutElement)new OptionsList(this.minecraft, this.width, (OptionsSubScreen)this));
        this.addOptions();
    }

    protected void addOptions() {
        this.list.addSmall(new OptionInstance[]{this.getPingVolumeOption(), this.getPingDurationOption()});
        this.list.addSmall(new OptionInstance[]{this.getPingDistanceOption(), this.getCorrectionPeriodOption()});
        this.list.addSmall(new OptionInstance[]{this.getItemIconsVisibleOption(), this.getDirectionIndicatorVisibleOption()});
        this.list.addSmall(new OptionInstance[]{this.getPlayerInfoModeOption(), this.getTeamColorModeOption()});
        this.list.addSmall(new OptionInstance[]{this.getPingSizeOption(), null});
        this.channelTextField = new EditBox(this.font, -1, -1, 200, 20, (Component)Component.empty());
        this.channelTextField.setMaxLength(128);
        this.channelTextField.setValue(this.config.getChannel());
        this.channelTextField.setResponder(this.config::setChannel);
        this.addWidget((GuiEventListener)this.channelTextField);
    }

    public void onClose() {
        ClientConfig.HANDLER.save();
        if (this.parent != null && this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        } else {
            super.onClose();
        }
    }

    public void repositionElements() {
        super.repositionElements();
        this.list.updateSize(this.width, this.layout);
    }

    public void render(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        super.render(ctx, mouseX, mouseY, delta);
        this.list.render(ctx, mouseX, mouseY, delta);
        int yOffset = 50 + 25 * this.list.children().size();
        this.channelTextField.setPosition(this.width / 2 - 100, yOffset);
        ctx.drawString(this.font, (Component)LanguageUtils.settings("channel").get(new Object[0]), this.width / 2 - 100, this.channelTextField.getY() - 12, -6250336);
        this.channelTextField.render(ctx, mouseX, mouseY, delta);
        if (this.channelTextField.getValue().isEmpty() && !this.channelTextField.isFocused()) {
            ctx.drawString(this.font, (Component)this.getChannelPlaceholder(), this.width / 2 - 100 + 4, this.channelTextField.getY() + 6, -1);
        }
        if (this.channelTextField.isHoveredOrFocused() && !this.channelTextField.isFocused()) {
            List<ClientTooltipComponent> clientTooltipComponentList = Tooltip.create((Component)LanguageUtils.settings("channel.tooltip").get(new Object[0])).toCharSequence(CommonClient.Game).stream().map(ClientTooltipComponent::create).toList();
            ctx.renderTooltip(this.font, clientTooltipComponentList, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
        }
    }

    private MutableComponent getChannelPlaceholder() {
        if (CommonClient.Game.player == null) {
            return Component.empty();
        }
        TeamContext teamContext = TeamContextHandler.getSelfContext();
        MutableComponent placeholder = teamContext == TeamContext.NONE ? LanguageUtils.of("value", "global").get(new Object[0]) : LanguageUtils.settings("channel").path("placeholder").get(LanguageUtils.of("value", teamContext.toString()).get(new Object[0]));
        return placeholder.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.DARK_GRAY);
    }

    private OptionInstance<Integer> getPingVolumeOption() {
        LanguageUtils text = LanguageUtils.settings("ping_volume");
        return OptionUtils.ofInt(text.getKey(), 0, 100, 1, value -> {
            if (value == 0) {
                return text.get(CommonComponents.OPTION_OFF);
            }
            return text.get(LanguageUtils.UNIT_PERCENT.get(value));
        }, this.config::getPingVolume, this.config::setPingVolume);
    }

    private OptionInstance<Integer> getPingDurationOption() {
        LanguageUtils text = LanguageUtils.settings("ping_duration");
        return OptionUtils.ofInt(text.getKey(), 1, 60, 1, value -> {
            if (value >= 60) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get(value));
        }, this.config::getPingDuration, this.config::setPingDuration);
    }

    private OptionInstance<Integer> getPingDistanceOption() {
        LanguageUtils text = LanguageUtils.settings("ping_distance");
        return OptionUtils.ofInt(text.getKey(), 0, 2048, 16, value -> {
            if (value == 0) {
                return text.get(LanguageUtils.VALUE_HIDDEN);
            }
            if (value >= 2048) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_METERS.get(value));
        }, this.config::getPingDistance, this.config::setPingDistance);
    }

    private OptionInstance<Float> getCorrectionPeriodOption() {
        LanguageUtils text = LanguageUtils.settings("correction_period");
        return OptionUtils.ofFloat(text.getKey(), 0.1f, 5.0f, 0.1f, value -> {
            if (value.floatValue() >= 5.0f) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get("%.1f".formatted(value)));
        }, this.config::getCorrectionPeriod, this.config::setCorrectionPeriod);
    }

    private OptionInstance<Boolean> getItemIconsVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("item_icon_visible").getKey(), this.config::isItemIconVisible, this.config::setItemIconVisible);
    }

    private OptionInstance<Boolean> getDirectionIndicatorVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("direction_indicator_visible").getKey(), this.config::isDirectionIndicatorVisible, this.config::setDirectionIndicatorVisible);
    }

    private OptionInstance<PlayerInfoMode> getPlayerInfoModeOption() {
        return OptionUtils.ofEnum(LanguageUtils.settings("player_info_mode").getKey(), PlayerInfoMode.class, mode -> LanguageUtils.of("value", mode.toString()).get(new Object[0]), mode -> {
            if (mode != PlayerInfoMode.HOLD) {
                return Component.empty();
            }
            MutableComponent kayPlayerListTitle = Component.translatable((String)CommonClient.Game.options.keyPlayerList.getName());
            Component kayPlayerListName = CommonClient.Game.options.keyPlayerList.getTranslatedKeyMessage();
            return LanguageUtils.settings("player_info_mode").path("hold", "tooltip").get(kayPlayerListTitle, kayPlayerListName);
        }, this.config::getPlayerInfoMode, this.config::setPlayerInfoMode);
    }

    private OptionInstance<TeamColorMode> getTeamColorModeOption() {
        return OptionUtils.ofEnum(LanguageUtils.settings("team_color_mode").getKey(), TeamColorMode.class, mode -> LanguageUtils.of("value", mode.toString()).get(new Object[0]), mode -> Component.empty(), this.config::getTeamColorMode, this.config::setTeamColorMode);
    }

    private OptionInstance<Integer> getPingSizeOption() {
        LanguageUtils text = LanguageUtils.settings("ping_size");
        return OptionUtils.ofInt(text.getKey(), 40, 300, 10, value -> text.get(LanguageUtils.UNIT_PERCENT.get(value)), this.config::getPingSize, this.config::setPingSize);
    }
}

