/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.PlayerInfoMode;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.integration.TeamContext;
import nx.pingwheel.common.integration.TeamContextHandler;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.screen.OptionUtils;

public class SettingsScreen
extends Screen {
    private static final int WHITE = 0xFFFFFF;
    private static final int GRAY = 0xA0A0A0;
    private final ClientConfig config = ClientConfig.HANDLER.getConfig();
    private Screen parent;
    private OptionsList list;
    private EditBox channelTextField;

    public SettingsScreen() {
        super((Component)LanguageUtils.settings("title").get(new Object[0]));
    }

    public SettingsScreen(Screen parent) {
        this();
        this.parent = parent;
    }

    public void m_86600_() {
        this.channelTextField.m_94120_();
        if (this.channelTextField.m_93696_() && this.m_7222_() != this.channelTextField) {
            this.m_7522_((GuiEventListener)this.channelTextField);
        }
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.m_232530_(this.getPingVolumeOption(), this.getPingDurationOption());
        this.list.m_232530_(this.getPingDistanceOption(), this.getCorrectionPeriodOption());
        this.list.m_232530_(this.getItemIconsVisibleOption(), this.getDirectionIndicatorVisibleOption());
        this.list.m_232530_(this.getPlayerInfoModeOption(), this.getTeamColorModeOption());
        this.list.m_232530_(this.getPingSizeOption(), null);
        int yOffset = 50 + 25 * this.list.m_6702_().size();
        this.channelTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, yOffset, 200, 20, (Component)Component.m_237119_());
        this.channelTextField.m_94199_(128);
        this.channelTextField.m_94144_(this.config.getChannel());
        this.channelTextField.m_94151_(this.config::setChannel);
        this.m_7787_((GuiEventListener)this.channelTextField);
        this.m_7787_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ - 27).m_253046_(200, 20).m_253136_());
    }

    public void m_7379_() {
        ClientConfig.HANDLER.save();
        if (this.parent != null && this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        } else {
            super.m_7379_();
        }
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_86412_(matrices, mouseX, mouseY, delta);
        SettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        SettingsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)LanguageUtils.settings("channel").get(new Object[0]), (int)(this.f_96543_ / 2 - 100), (int)(this.channelTextField.m_252907_() - 12), (int)0xA0A0A0);
        this.channelTextField.m_86412_(matrices, mouseX, mouseY, delta);
        if (this.channelTextField.m_94155_().isEmpty()) {
            SettingsScreen.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.getChannelPlaceholder(), (int)(this.f_96543_ / 2 - 100 + 4), (int)(this.channelTextField.m_252907_() + 6), (int)0xFFFFFF);
        }
        super.m_86412_(matrices, mouseX, mouseY, delta);
        if (this.channelTextField.m_198029_() && !this.channelTextField.m_93696_()) {
            this.m_96617_(matrices, Tooltip.m_257550_((Component)LanguageUtils.settings("channel.tooltip").get(new Object[0])).m_257408_(CommonClient.Game), mouseX, mouseY);
        }
    }

    private MutableComponent getChannelPlaceholder() {
        if (CommonClient.Game.f_91074_ == null) {
            return Component.m_237119_();
        }
        TeamContext teamContext = TeamContextHandler.getSelfContext();
        MutableComponent placeholder = teamContext == TeamContext.NONE ? LanguageUtils.of("value", "global").get(new Object[0]) : LanguageUtils.settings("channel").path("placeholder").get(LanguageUtils.of("value", teamContext.toString()).get(new Object[0]));
        return placeholder.m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GRAY);
    }

    private OptionInstance<Integer> getPingVolumeOption() {
        LanguageUtils text = LanguageUtils.settings("ping_volume");
        return OptionUtils.ofInt(text.getKey(), 0, 100, 1, value -> {
            if (value == 0) {
                return text.get(CommonComponents.f_130654_);
            }
            return text.get(LanguageUtils.UNIT_PERCENT.get(value));
        }, this.config::getPingVolume, this.config::setPingVolume);
    }

    private OptionInstance<Integer> getPingDurationOption() {
        LanguageUtils text = LanguageUtils.settings("ping_duration");
        return OptionUtils.ofInt(text.getKey(), 1, 60, 1, value -> {
            if (value >= 60) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get(value));
        }, this.config::getPingDuration, this.config::setPingDuration);
    }

    private OptionInstance<Integer> getPingDistanceOption() {
        LanguageUtils text = LanguageUtils.settings("ping_distance");
        return OptionUtils.ofInt(text.getKey(), 0, 2048, 16, value -> {
            if (value == 0) {
                return text.get(LanguageUtils.VALUE_HIDDEN);
            }
            if (value >= 2048) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_METERS.get(value));
        }, this.config::getPingDistance, this.config::setPingDistance);
    }

    private OptionInstance<Float> getCorrectionPeriodOption() {
        LanguageUtils text = LanguageUtils.settings("correction_period");
        return OptionUtils.ofFloat(text.getKey(), 0.1f, 5.0f, 0.1f, value -> {
            if (value.floatValue() >= 5.0f) {
                return text.get(LanguageUtils.VALUE_INFINITE);
            }
            return text.get(LanguageUtils.UNIT_SECONDS.get("%.1f".formatted(value)));
        }, this.config::getCorrectionPeriod, this.config::setCorrectionPeriod);
    }

    private OptionInstance<Boolean> getItemIconsVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("item_icon_visible").getKey(), this.config::isItemIconVisible, this.config::setItemIconVisible);
    }

    private OptionInstance<Boolean> getDirectionIndicatorVisibleOption() {
        return OptionUtils.ofBool(LanguageUtils.settings("direction_indicator_visible").getKey(), this.config::isDirectionIndicatorVisible, this.config::setDirectionIndicatorVisible);
    }

    private OptionInstance<PlayerInfoMode> getPlayerInfoModeOption() {
        return OptionUtils.ofEnum(LanguageUtils.settings("player_info_mode").getKey(), PlayerInfoMode.class, mode -> LanguageUtils.of("value", mode.toString()).get(new Object[0]), mode -> {
            if (mode != PlayerInfoMode.HOLD) {
                return Component.m_237119_();
            }
            MutableComponent kayPlayerListTitle = Component.m_237115_((String)CommonClient.Game.f_91066_.f_92099_.m_90860_());
            Component kayPlayerListName = CommonClient.Game.f_91066_.f_92099_.m_90863_();
            return LanguageUtils.settings("player_info_mode").path("hold", "tooltip").get(kayPlayerListTitle, kayPlayerListName);
        }, this.config::getPlayerInfoMode, this.config::setPlayerInfoMode);
    }

    private OptionInstance<TeamColorMode> getTeamColorModeOption() {
        return OptionUtils.ofEnum(LanguageUtils.settings("team_color_mode").getKey(), TeamColorMode.class, mode -> LanguageUtils.of("value", mode.toString()).get(new Object[0]), mode -> Component.m_237119_(), this.config::getTeamColorMode, this.config::setTeamColorMode);
    }

    private OptionInstance<Integer> getPingSizeOption() {
        LanguageUtils text = LanguageUtils.settings("ping_size");
        return OptionUtils.ofInt(text.getKey(), 40, 300, 10, value -> text.get(LanguageUtils.UNIT_PERCENT.get(value)), this.config::getPingSize, this.config::setPingSize);
    }
}

