/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.screen.SettingsScreen;
import org.apache.logging.log4j.util.TriConsumer;

public class ClientCommandBuilder {
    private ClientCommandBuilder() {
    }

    public static <S> LiteralArgumentBuilder<S> build(TriConsumer<CommandContext<S>, Boolean, MutableComponent> responseHandler) {
        LanguageUtils langConfig = LanguageUtils.command("config");
        LanguageUtils langChannel = LanguageUtils.command("channel");
        LiteralArgumentBuilder cmdChannel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"channel").executes(context -> {
            String currentChannel = ClientConfig.HANDLER.getConfig().getChannel();
            if (currentChannel.isEmpty()) {
                responseHandler.accept((Object)context, (Object)true, (Object)langChannel.path("get", "response", "default").get(new Object[0]));
            } else {
                responseHandler.accept((Object)context, (Object)true, (Object)langChannel.path("get", "response").get(Component.literal((String)currentChannel).withStyle(ChatFormatting.YELLOW)));
            }
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"channel_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String newChannel = (String)context.getArgument("channel_name", String.class);
            if (newChannel.length() > 128) {
                responseHandler.accept((Object)context, (Object)false, (Object)langChannel.path("set", "reject").get(128));
                return 0;
            }
            ClientConfig.HANDLER.getConfig().setChannel(newChannel);
            ClientConfig.HANDLER.save();
            if (newChannel.isEmpty()) {
                responseHandler.accept((Object)context, (Object)true, (Object)langChannel.path("set", "response", "default").get(new Object[0]));
            } else {
                responseHandler.accept((Object)context, (Object)true, (Object)langChannel.path("set", "response").get(Component.literal((String)newChannel).withStyle(ChatFormatting.YELLOW)));
            }
            return 1;
        }));
        LiteralArgumentBuilder cmdConfig = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"config").executes(context -> {
            CommonClient.Game.schedule(() -> CommonClient.Game.setScreen((Screen)new SettingsScreen()));
            return 1;
        });
        Command helpCallback = context -> {
            responseHandler.accept((Object)context, (Object)true, (Object)LanguageUtils.join(Component.empty(), Component.literal((String)"/pingwheel config"), langConfig.path("description").wrapped().withStyle(ChatFormatting.GRAY), Component.literal((String)"/pingwheel channel"), langChannel.path("get", "description").wrapped().withStyle(ChatFormatting.GRAY), Component.literal((String)"/pingwheel channel <channel_name>"), langChannel.path("set", "description").wrapped().withStyle(ChatFormatting.GRAY)));
            return 1;
        };
        LiteralArgumentBuilder cmdHelp = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").executes(helpCallback);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"pingwheel").executes(helpCallback)).then((ArgumentBuilder)cmdHelp)).then((ArgumentBuilder)cmdConfig)).then((ArgumentBuilder)cmdChannel);
    }
}

