/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.forge.platform;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.EventNetworkChannel;
import net.minecraftforge.network.PacketDistributor;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.network.IPacket;
import nx.pingwheel.common.platform.IPlatformNetworkService;

public class PlatformNetworkServiceImpl
implements IPlatformNetworkService {
    public static final Map<ResourceLocation, EventNetworkChannel> CHANNEL_MAP = new HashMap<ResourceLocation, EventNetworkChannel>();

    @Override
    public void sendToServer(IPacket packet) {
        ClientPacketListener connection = CommonClient.Game.getConnection();
        if (connection == null) {
            return;
        }
        EventNetworkChannel chan = CHANNEL_MAP.get(packet.getId());
        if (chan == null || !chan.isRemotePresent(connection.getConnection())) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        packet.write(buf);
        chan.send((Object)buf, PacketDistributor.SERVER.noArg());
    }

    @Override
    public void sendToClient(IPacket packet, ServerPlayer player) {
        EventNetworkChannel chan = CHANNEL_MAP.get(packet.getId());
        if (chan == null || !chan.isRemotePresent(player.connection.getConnection())) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        packet.write(buf);
        chan.send((Object)buf, PacketDistributor.PLAYER.with((Object)player));
    }
}

