/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.resource.ResourceConstants;
import nx.pingwheel.common.resource.ResourceReloadListener;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class DrawContext {
    private static final int SHADOW_BLACK = ARGB.color((int)64, (int)0, (int)0, (int)0);
    private GuiGraphics guiGraphics;
    private Matrix3x2fStack matrices;

    public DrawContext(GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.matrices = guiGraphics.pose();
    }

    public void renderLabel(Component text, float yOffset, PlayerInfo player, int color) {
        int extraWidth = player != null ? 10 : 0;
        float f = CommonClient.Game.font.width((FormattedText)text) + extraWidth;
        Objects.requireNonNull(CommonClient.Game.font);
        Vec2 textMetrics = new Vec2(f, 9.0f);
        Vec2 textOffset = textMetrics.scale(-0.5f).add(new Vec2(0.0f, textMetrics.y * yOffset));
        this.matrices.pushMatrix();
        this.matrices.translate(textOffset.x, textOffset.y);
        this.guiGraphics.fill(-2, -2, (int)textMetrics.x + 1, (int)textMetrics.y, SHADOW_BLACK);
        this.guiGraphics.drawString(CommonClient.Game.font, text, extraWidth, 0, color, false);
        if (player != null) {
            this.matrices.translate(-0.5f, -0.5f);
            this.renderPlayerHead(player);
        }
        this.matrices.popMatrix();
    }

    public void renderPlayerHead(PlayerInfo player) {
        ResourceLocation texture = player.getSkin().body().texturePath();
        GlStateManager._enableBlend();
        this.guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, 0, 0, 8.0f, 8.0f, 8, 8, 64, 64);
        this.guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, 0, 0, 40.0f, 8.0f, 8, 8, 64, 64);
        GlStateManager._disableBlend();
    }

    public void renderPing(ItemStack itemStack, boolean drawItemIcon, int color) {
        if (itemStack != null && drawItemIcon) {
            this.renderGuiItemModel(itemStack);
        } else if (ResourceReloadListener.hasCustomTexture()) {
            this.renderTexture(ResourceConstants.PING_TEXTURE_ID, 12, color);
        } else {
            this.renderDefaultPingIcon(color);
        }
    }

    public void renderGuiItemModel(ItemStack itemStack) {
        this.guiGraphics.renderItem(itemStack, -8, -8, -150);
    }

    public void renderDefaultPingIcon(int color) {
        this.matrices.pushMatrix();
        MathUtils.rotateZ((Matrix3x2f)this.matrices, 0.7853982f);
        this.matrices.translate(-2.5f, -2.5f);
        this.guiGraphics.fill(0, 0, 5, 5, color);
        this.matrices.popMatrix();
    }

    public void renderTexture(ResourceLocation texture, int size, int color) {
        int offset = size / -2;
        GlStateManager._enableBlend();
        this.guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, offset, offset, 0.0f, 0.0f, size, size, size, size, color);
        GlStateManager._disableBlend();
    }

    public void renderArrowIcon(int color) {
        this.renderTexture(ResourceConstants.ARROW_TEXTURE_ID, 10, color);
    }

    public Matrix3x2fStack getMatrices() {
        return this.matrices;
    }
}

