/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.network;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.network.IPacket;
import nx.pingwheel.common.network.PacketHandler;
import nx.pingwheel.common.network.PingLocationC2SPacket;
import org.jetbrains.annotations.NotNull;

public record PingLocationS2CPacket(String channel, Vec3 pos, UUID entity, int sequence, int dimension, UUID author) implements IPacket
{
    public static final ResourceLocation PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"ping-wheel-s2c", (String)"ping-location");
    public static final CustomPacketPayload.Type<PingLocationS2CPacket> PACKET_TYPE = new CustomPacketPayload.Type(PACKET_ID);

    public PingLocationS2CPacket() {
        this(null, null, null, 0, 0, null);
    }

    public PingLocationS2CPacket(FriendlyByteBuf buf) {
        this(buf.readUtf(128), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readBoolean() ? buf.readUUID() : null, buf.readInt(), buf.readInt(), buf.readUUID());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.channel, 128);
        buf.writeDouble(this.pos.x);
        buf.writeDouble(this.pos.y);
        buf.writeDouble(this.pos.z);
        buf.writeBoolean(this.entity != null);
        if (this.entity != null) {
            buf.writeUUID(this.entity);
        }
        buf.writeInt(this.sequence);
        buf.writeInt(this.dimension);
        buf.writeUUID(this.author);
    }

    @Override
    public boolean isCorrupt() {
        return this.channel == null;
    }

    @Override
    public ResourceLocation getId() {
        return PACKET_ID;
    }

    public static PingLocationS2CPacket readSafe(FriendlyByteBuf buf) {
        return PacketHandler.readSafe(buf, PingLocationS2CPacket.class);
    }

    public static PingLocationS2CPacket fromClientPacket(PingLocationC2SPacket clientPacket, UUID author) {
        return new PingLocationS2CPacket(clientPacket.channel(), clientPacket.pos(), clientPacket.entity(), clientPacket.sequence(), clientPacket.dimension(), author);
    }

    @NotNull
    public CustomPacketPayload.Type<PingLocationS2CPacket> type() {
        return PACKET_TYPE;
    }
}

