/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.forge.platform;

import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nx.pingwheel.common.platform.IPlatformClientEventService;

public class PlatformClientEventServiceImpl
implements IPlatformClientEventService {
    @Override
    public void registerTickStartEvent(Runnable callback) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickEventEventHandler(callback));
    }

    @Override
    public void registerJoinServerEvent(Runnable callback) {
        MinecraftForge.EVENT_BUS.register((Object)new JoinServerEventHandler(callback));
    }

    @Override
    public void registerLeaveServerEvent(Runnable callback) {
        MinecraftForge.EVENT_BUS.register((Object)new LeaveServerEventHandler(callback));
    }

    private record ClientTickEventEventHandler(Runnable callback) {
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase.equals((Object)TickEvent.Phase.START)) {
                this.callback.run();
            }
        }
    }

    private record JoinServerEventHandler(Runnable callback) {
        @SubscribeEvent
        public void onClientConnectedToServer(ClientPlayerNetworkEvent.LoggingIn event) {
            this.callback.run();
        }
    }

    private record LeaveServerEventHandler(Runnable callback) {
        @SubscribeEvent
        public void onClientDisconnectedFromServer(ClientPlayerNetworkEvent.LoggingOut event) {
            this.callback.run();
        }
    }
}

