/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.compat;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.platform.IPlatformContextService;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.util.InputUtils;

public class LegacyMigrationHandler {
    private static boolean gameOptionsSaveNeeded = false;
    private static boolean notifyDeprecatedResourcePack = false;

    public static void migrateConfig(String configExtension) {
        Path legacyConfigPath = IPlatformContextService.INSTANCE.resolveConfigDir("ping-wheel" + configExtension);
        Path newConfigPath = IPlatformContextService.INSTANCE.resolveConfigDir("pingwheel" + configExtension);
        if (!Files.exists(legacyConfigPath, new LinkOption[0])) {
            return;
        }
        try {
            Files.move(legacyConfigPath, newConfigPath, StandardCopyOption.REPLACE_EXISTING);
            Global.LOGGER.info("Renamed legacy config: %s -> %s".formatted(legacyConfigPath, newConfigPath));
        }
        catch (IOException e) {
            Global.LOGGER.error("Failed to rename legacy config: %s".formatted(e));
        }
    }

    public static void migrateKeyMappings() {
        Path optionsPath = IPlatformContextService.INSTANCE.resolveGameDir("options.txt");
        if (!Files.exists(optionsPath, new LinkOption[0])) {
            Global.LOGGER.warn("Unable to find game options for migration routine");
            return;
        }
        try {
            List<String> lines = Files.readAllLines(optionsPath);
            for (String line : lines) {
                if (!line.contains("ping-wheel")) continue;
                String keyString = line.split(":")[1];
                InputConstants.Key keyKey = InputConstants.getKey((String)keyString);
                if (line.contains("ping-location")) {
                    InputUtils.KEY_BINDING_PING.setKey(keyKey);
                    Global.LOGGER.info("Migrated KEY_BINDING_PING: %s".formatted(keyKey));
                } else if (line.contains("open-settings")) {
                    InputUtils.KEY_BINDING_SETTINGS.setKey(keyKey);
                    Global.LOGGER.info("Migrated KEY_BINDING_SETTINGS: %s".formatted(keyKey));
                }
                gameOptionsSaveNeeded = true;
            }
        }
        catch (IOException e) {
            Global.LOGGER.error("Failed to read options.txt to transfer legacy keybinds: %s".formatted(e));
        }
    }

    public static void onTick() {
        if (CommonClient.Game == null) {
            return;
        }
        if (gameOptionsSaveNeeded) {
            CommonClient.Game.options.save();
            gameOptionsSaveNeeded = false;
        }
        if (notifyDeprecatedResourcePack && CommonClient.Game.player != null) {
            MutableComponent msg = Component.literal((String)"a resource pack is using the old mod-id, please update ");
            msg.append((Component)Component.literal((String)"\"assets/ping-wheel\"").withStyle(ChatFormatting.GRAY));
            msg.append(" to ");
            msg.append((Component)Component.literal((String)"\"assets/pingwheel\"").withStyle(ChatFormatting.GRAY));
            CommonClient.Game.player.displayClientMessage((Component)LanguageUtils.withModPrefix(msg), false);
            notifyDeprecatedResourcePack = false;
        }
    }

    public static void checkResources(ResourceManager resourceManager) {
        List<ResourceLocation> legacyTextures = List.of(ResourceLocation.fromNamespaceAndPath((String)"ping-wheel", (String)"ping"), ResourceLocation.fromNamespaceAndPath((String)"ping-wheel", (String)"textures/ping.png"), ResourceLocation.fromNamespaceAndPath((String)"ping-wheel", (String)"textures/arrow.png"));
        notifyDeprecatedResourcePack = false;
        for (ResourceLocation resource : legacyTextures) {
            notifyDeprecatedResourcePack |= !resourceManager.getResourceStack(resource).isEmpty();
        }
    }
}

