/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.GameContext;
import nx.pingwheel.common.core.PingManager;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.render.DirectionIndicatorRenderer;
import nx.pingwheel.common.render.DrawContext;
import nx.pingwheel.common.render.PingLocationRenderer;

public class OverlayRenderer {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();

    private OverlayRenderer() {
    }

    public static void draw(GuiGraphics guiGraphics, float tickDelta) {
        ArrayList<PingView> pingRepo = PingManager.PING_REPO;
        if (CommonClient.Game.player == null || pingRepo.isEmpty()) {
            return;
        }
        PoseStack m = guiGraphics.pose();
        DrawContext ctx = new DrawContext(guiGraphics);
        boolean showDirectionIndicator = CLIENT_CONFIG.isDirectionIndicatorVisible();
        if (showDirectionIndicator) {
            DirectionIndicatorRenderer.prepareSafeZone();
        }
        m.pushPose();
        m.translate(0.0f, 0.0f, (float)(-pingRepo.size()) * 16.0f);
        for (PingView ping : pingRepo) {
            boolean behindCamera;
            ScreenPos screenPos = ping.getScreenPos();
            if (screenPos == null || ping.dimension != GameContext.getDimension() || (behindCamera = screenPos.isBehindCamera()) && !showDirectionIndicator) continue;
            m.translate(0.0f, 0.0f, 16.0f);
            if (showDirectionIndicator) {
                DirectionIndicatorRenderer.draw(ctx, ping);
            }
            if (behindCamera) continue;
            PingLocationRenderer.draw(ctx, ping);
        }
        m.popPose();
    }
}

