/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.util;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.CommonClient;

public class DirectionalSoundInstance
extends AbstractTickableSoundInstance {
    private final Vec3 pos;

    public DirectionalSoundInstance(SoundEvent sound, SoundSource category, float volume, float pitch, Vec3 pos) {
        super(sound, category, RandomSource.create());
        this.volume = volume;
        this.pitch = pitch;
        this.pos = pos;
        this.tick();
    }

    public void tick() {
        if (CommonClient.Game.player == null) {
            this.stop();
            return;
        }
        Vec3 playerPos = CommonClient.Game.player.position();
        Vec3 vecBetween = playerPos.vectorTo(this.pos);
        double mappedDistance = Math.min(vecBetween.length(), 64.0) / 64.0 * 14.0;
        Vec3 soundDirection = vecBetween.normalize().scale(mappedDistance);
        Vec3 soundPos = playerPos.add(soundDirection);
        this.x = soundPos.x;
        this.y = soundPos.y;
        this.z = soundPos.z;
    }
}

