/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.compat;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.platform.IPlatformContextService;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.util.InputUtils;

public class LegacyMigrationHandler {
    private static boolean gameOptionsSaveNeeded = false;
    private static boolean notifyDeprecatedResourcePack = false;

    public static void migrateConfig(String configExtension) {
        Path legacyConfigPath = IPlatformContextService.INSTANCE.resolveConfigDir("ping-wheel" + configExtension);
        Path newConfigPath = IPlatformContextService.INSTANCE.resolveConfigDir("pingwheel" + configExtension);
        if (!Files.exists(legacyConfigPath, new LinkOption[0])) {
            return;
        }
        try {
            Files.move(legacyConfigPath, newConfigPath, StandardCopyOption.REPLACE_EXISTING);
            Global.LOGGER.info("Renamed legacy config: %s -> %s".formatted(legacyConfigPath, newConfigPath));
        }
        catch (IOException e) {
            Global.LOGGER.error("Failed to rename legacy config: %s".formatted(e));
        }
    }

    public static void migrateKeyMappings() {
        Path optionsPath = IPlatformContextService.INSTANCE.resolveGameDir("options.txt");
        if (!Files.exists(optionsPath, new LinkOption[0])) {
            Global.LOGGER.warn("Unable to find game options for migration routine");
            return;
        }
        try {
            List<String> lines = Files.readAllLines(optionsPath);
            for (String line : lines) {
                if (!line.contains("ping-wheel")) continue;
                String keyString = line.split(":")[1];
                InputConstants.Key keyKey = InputConstants.m_84851_((String)keyString);
                if (line.contains("ping-location")) {
                    InputUtils.KEY_BINDING_PING.m_90848_(keyKey);
                    Global.LOGGER.info("Migrated KEY_BINDING_PING: %s".formatted(keyKey));
                } else if (line.contains("open-settings")) {
                    InputUtils.KEY_BINDING_SETTINGS.m_90848_(keyKey);
                    Global.LOGGER.info("Migrated KEY_BINDING_SETTINGS: %s".formatted(keyKey));
                }
                gameOptionsSaveNeeded = true;
            }
        }
        catch (IOException e) {
            Global.LOGGER.error("Failed to read options.txt to transfer legacy keybinds: %s".formatted(e));
        }
    }

    public static void onTick() {
        if (CommonClient.Game == null) {
            return;
        }
        if (gameOptionsSaveNeeded) {
            CommonClient.Game.f_91066_.m_92169_();
            gameOptionsSaveNeeded = false;
        }
        if (notifyDeprecatedResourcePack && CommonClient.Game.f_91074_ != null) {
            MutableComponent msg = Component.m_237113_((String)"a resource pack is using the old mod-id, please update ");
            msg.m_7220_((Component)Component.m_237113_((String)"\"assets/ping-wheel\"").m_130940_(ChatFormatting.GRAY));
            msg.m_130946_(" to ");
            msg.m_7220_((Component)Component.m_237113_((String)"\"assets/pingwheel\"").m_130940_(ChatFormatting.GRAY));
            CommonClient.Game.f_91074_.m_213846_((Component)LanguageUtils.withModPrefix(msg));
            notifyDeprecatedResourcePack = false;
        }
    }

    public static void checkResources(ResourceManager resourceManager) {
        List<ResourceLocation> legacyTextures = List.of(new ResourceLocation("ping-wheel", "ping"), new ResourceLocation("ping-wheel", "textures/ping.png"), new ResourceLocation("ping-wheel", "textures/arrow.png"));
        notifyDeprecatedResourcePack = false;
        for (ResourceLocation resource : legacyTextures) {
            notifyDeprecatedResourcePack |= !resourceManager.m_213829_(resource).isEmpty();
        }
    }
}

