/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.phys.Vec2;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.render.DrawContext;

public class DirectionIndicatorRenderer {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static final int WHITE = -1;
    private static Vec2 screenSize;
    private static Vec2 safeZoneTopLeft;
    private static Vec2 safeZoneBottomRight;
    private static Vec2 safeScreenCenter;

    private DirectionIndicatorRenderer() {
    }

    public static void prepareSafeZone() {
        Window wnd = CommonClient.Game.m_91268_();
        screenSize = new Vec2((float)wnd.m_85445_(), (float)wnd.m_85446_());
        safeZoneTopLeft = new Vec2((float)CLIENT_CONFIG.getSafeZoneLeft(), (float)CLIENT_CONFIG.getSafeZoneTop());
        safeZoneBottomRight = new Vec2(DirectionIndicatorRenderer.screenSize.f_82470_ - (float)CLIENT_CONFIG.getSafeZoneRight(), DirectionIndicatorRenderer.screenSize.f_82471_ - (float)CLIENT_CONFIG.getSafeZoneBottom());
        safeScreenCenter = new Vec2((DirectionIndicatorRenderer.safeZoneBottomRight.f_82470_ - DirectionIndicatorRenderer.safeZoneTopLeft.f_82470_) * 0.5f, (DirectionIndicatorRenderer.safeZoneBottomRight.f_82471_ - DirectionIndicatorRenderer.safeZoneTopLeft.f_82471_) * 0.5f);
    }

    public static void draw(DrawContext ctx, PingView ping) {
        boolean isOffScreen;
        ScreenPos screenPos = ping.getScreenPos();
        if (screenPos == null) {
            return;
        }
        boolean behindCamera = screenPos.isBehindCamera();
        boolean bl = isOffScreen = behindCamera || !screenPos.isInBounds(Vec2.f_82462_, screenSize);
        if (!isOffScreen) {
            return;
        }
        Vec2 pingDirectionVec = new Vec2(screenPos.x - DirectionIndicatorRenderer.safeZoneTopLeft.f_82470_ - DirectionIndicatorRenderer.safeScreenCenter.f_82470_, screenPos.y - DirectionIndicatorRenderer.safeZoneTopLeft.f_82471_ - DirectionIndicatorRenderer.safeScreenCenter.f_82471_);
        if (behindCamera) {
            pingDirectionVec = pingDirectionVec.m_165903_(-1.0f);
        }
        PoseStack m = ctx.getMatrices();
        float pingScale = ping.getScale();
        float pingSize = (float)CLIENT_CONFIG.getPingSize() / 100.0f;
        float pingAngle = (float)Math.atan2(pingDirectionVec.f_82471_, pingDirectionVec.f_82470_);
        Vec2 edgePosition = MathUtils.calculateAngleRectIntersection(pingAngle, safeZoneTopLeft, safeZoneBottomRight);
        double indicatorOffsetX = Math.cos((double)pingAngle + Math.PI) * 12.0;
        double indicatorOffsetY = Math.sin((double)pingAngle + Math.PI) * 12.0;
        m.m_85836_();
        m.m_252880_(edgePosition.f_82470_, edgePosition.f_82471_, 0.0f);
        boolean useTeamColor = CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.FULL || CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.PING_ONLY;
        int pingColor = useTeamColor ? ping.getTeamColor() : -1;
        m.m_85836_();
        m.m_85841_(pingScale, pingScale, 1.0f);
        m.m_85837_(indicatorOffsetX, indicatorOffsetY, 0.0);
        ctx.renderPing(ping.getItemStack(), CLIENT_CONFIG.isItemIconVisible(), pingColor);
        m.m_85849_();
        m.m_85836_();
        MathUtils.rotateZ(m, pingAngle);
        m.m_85841_(pingSize, pingSize, 1.0f);
        m.m_85841_(0.25f, 0.25f, 1.0f);
        m.m_252880_(-5.0f, 0.0f, 0.0f);
        ctx.renderArrowIcon(pingColor);
        m.m_85849_();
        m.m_85849_();
    }
}

