/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.forge;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.EventNetworkChannel;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.command.ClientCommandBuilder;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.resource.ResourceReloadListener;
import nx.pingwheel.common.screen.SettingsScreen;
import nx.pingwheel.forge.ForgeMain;

public class ForgeClient {
    public ForgeClient() {
        CommonClient.INSTANCE.onInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeClient.registerPacketHandler(ForgeMain.PING_LOCATION_CHANNEL_S2C, PingLocationS2CPacket::readSafe, CommonClient.INSTANCE::onPingLocationPacket);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> event.registerReloadListener((PreparableReloadListener)new ResourceReloadListener()));
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> new SettingsScreen((Screen)parent)));
    }

    public static <T> void registerPacketHandler(EventNetworkChannel channel, Function<FriendlyByteBuf, T> packetReader, Consumer<T> packetHandler) {
        channel.addListener(event -> {
            CustomPayloadEvent.Context ctx = event.getSource();
            FriendlyByteBuf payload = event.getPayload();
            if (payload != null) {
                Object packet = packetReader.apply(payload);
                ctx.enqueueWork(() -> packetHandler.accept(packet));
            }
            ctx.setPacketHandled(true);
        });
    }

    @SubscribeEvent
    public void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register(ClientCommandBuilder.build((context, success, response) -> {
            if (success.booleanValue()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> LanguageUtils.withModPrefix(response), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)LanguageUtils.withModPrefix(response));
            }
        }));
    }
}

