/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import net.minecraft.class_1041;
import net.minecraft.class_241;
import net.minecraft.class_4587;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.render.DrawContext;

public class DirectionIndicatorRenderer {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static final int WHITE = -1;
    private static class_241 screenSize;
    private static class_241 safeZoneTopLeft;
    private static class_241 safeZoneBottomRight;
    private static class_241 safeScreenCenter;

    private DirectionIndicatorRenderer() {
    }

    public static void prepareSafeZone() {
        class_1041 wnd = CommonClient.Game.method_22683();
        screenSize = new class_241((float)wnd.method_4486(), (float)wnd.method_4502());
        safeZoneTopLeft = new class_241((float)CLIENT_CONFIG.getSafeZoneLeft(), (float)CLIENT_CONFIG.getSafeZoneTop());
        safeZoneBottomRight = new class_241(DirectionIndicatorRenderer.screenSize.field_1343 - (float)CLIENT_CONFIG.getSafeZoneRight(), DirectionIndicatorRenderer.screenSize.field_1342 - (float)CLIENT_CONFIG.getSafeZoneBottom());
        safeScreenCenter = new class_241((DirectionIndicatorRenderer.safeZoneBottomRight.field_1343 - DirectionIndicatorRenderer.safeZoneTopLeft.field_1343) * 0.5f, (DirectionIndicatorRenderer.safeZoneBottomRight.field_1342 - DirectionIndicatorRenderer.safeZoneTopLeft.field_1342) * 0.5f);
    }

    public static void draw(DrawContext ctx, PingView ping) {
        boolean isOffScreen;
        ScreenPos screenPos = ping.getScreenPos();
        if (screenPos == null) {
            return;
        }
        boolean behindCamera = screenPos.isBehindCamera();
        boolean bl = isOffScreen = behindCamera || !screenPos.isInBounds(class_241.field_1340, screenSize);
        if (!isOffScreen) {
            return;
        }
        class_241 pingDirectionVec = new class_241(screenPos.x - DirectionIndicatorRenderer.safeZoneTopLeft.field_1343 - DirectionIndicatorRenderer.safeScreenCenter.field_1343, screenPos.y - DirectionIndicatorRenderer.safeZoneTopLeft.field_1342 - DirectionIndicatorRenderer.safeScreenCenter.field_1342);
        if (behindCamera) {
            pingDirectionVec = pingDirectionVec.method_35582(-1.0f);
        }
        class_4587 m = ctx.getMatrices();
        float pingScale = ping.getScale();
        float pingSize = (float)CLIENT_CONFIG.getPingSize() / 100.0f;
        float pingAngle = (float)Math.atan2(pingDirectionVec.field_1342, pingDirectionVec.field_1343);
        class_241 edgePosition = MathUtils.calculateAngleRectIntersection(pingAngle, safeZoneTopLeft, safeZoneBottomRight);
        double indicatorOffsetX = Math.cos((double)pingAngle + Math.PI) * 12.0;
        double indicatorOffsetY = Math.sin((double)pingAngle + Math.PI) * 12.0;
        m.method_22903();
        m.method_46416(edgePosition.field_1343, edgePosition.field_1342, 0.0f);
        boolean useTeamColor = CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.FULL || CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.PING_ONLY;
        int pingColor = useTeamColor ? ping.getTeamColor() : -1;
        m.method_22903();
        m.method_22905(pingScale, pingScale, 1.0f);
        m.method_22904(indicatorOffsetX, indicatorOffsetY, 0.0);
        ctx.renderPing(ping.getItemStack(), CLIENT_CONFIG.isItemIconVisible(), pingColor);
        m.method_22909();
        m.method_22903();
        MathUtils.rotateZ(m, pingAngle);
        m.method_22905(pingSize, pingSize, 1.0f);
        m.method_22905(0.25f, 0.25f, 1.0f);
        m.method_46416(-5.0f, 0.0f, 0.0f);
        ctx.renderArrowIcon(pingColor);
        m.method_22909();
        m.method_22909();
    }
}

