/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_809;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.resource.ResourceConstants;
import nx.pingwheel.common.resource.ResourceReloadListener;

public class DrawContext {
    private static final int SHADOW_BLACK = class_5253.class_5254.method_27764((int)64, (int)0, (int)0, (int)0);
    private static final int LIGHT_VALUE_MAX = 0xF000F0;
    private class_4587 matrices;

    public DrawContext(class_4587 matrices) {
        this.matrices = matrices;
    }

    public void renderLabel(class_2561 text, float yOffset, class_640 player, int color) {
        float extraWidth = player != null ? 10.0f : 0.0f;
        float f = (float)CommonClient.Game.field_1772.method_27525((class_5348)text) + extraWidth;
        Objects.requireNonNull(CommonClient.Game.field_1772);
        class_241 textMetrics = new class_241(f, 9.0f);
        class_241 textOffset = textMetrics.method_35582(-0.5f).method_35586(new class_241(0.0f, textMetrics.field_1342 * yOffset));
        this.matrices.method_22903();
        this.matrices.method_46416(textOffset.field_1343, textOffset.field_1342, 0.0f);
        class_332.method_25294((class_4587)this.matrices, (int)-2, (int)-2, (int)((int)textMetrics.field_1343 + 1), (int)((int)textMetrics.field_1342), (int)SHADOW_BLACK);
        CommonClient.Game.field_1772.method_30883(this.matrices, text, extraWidth, 0.0f, color);
        if (player != null) {
            this.matrices.method_22904(-0.5, -0.5, 0.0);
            this.renderPlayerHead(player);
        }
        this.matrices.method_22909();
    }

    public void renderPlayerHead(class_640 player) {
        RenderSystem.setShaderTexture((int)0, (class_2960)player.method_2968());
        RenderSystem.enableBlend();
        class_332.method_25291((class_4587)this.matrices, (int)0, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        class_332.method_25291((class_4587)this.matrices, (int)0, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.disableBlend();
    }

    public void renderPing(class_1799 itemStack, boolean drawItemIcon, int color) {
        if (itemStack != null && drawItemIcon) {
            this.renderGuiItemModel(itemStack);
        } else if (ResourceReloadListener.hasCustomTexture()) {
            this.renderTexture(ResourceConstants.PING_TEXTURE_ID, 12, color);
        } else {
            this.renderDefaultPingIcon(color);
        }
    }

    public void renderGuiItemModel(class_1799 itemStack) {
        boolean bl;
        class_1087 model = CommonClient.Game.method_1480().method_4019(itemStack, null, null, 0);
        CommonClient.Game.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_34425(this.matrices.method_23760().method_23761());
        matrixStack.method_46416(0.0f, 0.0f, -0.5f);
        matrixStack.method_22905(16.0f, -16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 immediate = CommonClient.Game.method_22940().method_23000();
        boolean bl2 = bl = !model.method_24304();
        if (bl) {
            class_308.method_24210();
        }
        class_4587 matrixStackDummy = new class_4587();
        CommonClient.Game.method_1480().method_23179(itemStack, class_809.class_811.field_4317, false, matrixStackDummy, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
        immediate.method_22993();
        RenderSystem.enableDepthTest();
        if (bl) {
            class_308.method_24211();
        }
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public void renderDefaultPingIcon(int color) {
        this.matrices.method_22903();
        MathUtils.rotateZ(this.matrices, 0.7853982f);
        this.matrices.method_22904(-2.5, -2.5, 0.0);
        class_332.method_25294((class_4587)this.matrices, (int)0, (int)0, (int)5, (int)5, (int)color);
        this.matrices.method_22909();
    }

    public void renderTexture(class_2960 texture, int size, int color) {
        int offset = size / -2;
        float a = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.enableBlend();
        class_332.method_25291((class_4587)this.matrices, (int)offset, (int)offset, (int)0, (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
        RenderSystem.disableBlend();
    }

    public void renderArrowIcon(int color) {
        this.renderTexture(ResourceConstants.ARROW_TEXTURE_ID, 10, color);
    }

    public class_4587 getMatrices() {
        return this.matrices;
    }
}

