/*
 * Decompiled with CFR 0.152.
 */
package com.Portality.ccomunityboxes.boxes;

import com.Portality.ccomunityboxes.BoxModels;
import com.Portality.ccomunityboxes.boxes.Boxes;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.chute.ChuteBlock;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CustomBoxEntity
extends PackageEntity {
    public String model;

    public CustomBoxEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public CustomBoxEntity(EntityType<?> entityType, Level world, double x, double y, double z, String model) {
        super(entityType, world);
        this.setPos(x, y, z);
        this.model = model;
        this.refreshDimensions();
    }

    public PartialModel getModel() {
        return BoxModels.BOXES.get(this.model);
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> boxBuilder = builder;
        return boxBuilder.sized(1.0f, 1.0f);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.setPos(this.getX(), this.getY(), this.getZ());
    }

    public static PackageEntity fromItemStack(Level world, Vec3 position, ItemStack itemstack) {
        PackageEntity packageEntity = (PackageEntity)Boxes.CUSTOM_PACKAGE.create(world);
        packageEntity.setPos(position);
        packageEntity.setBox(itemstack);
        return packageEntity;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
    }

    public static CustomBoxEntity fromDroppedItem(Level world, Entity originalEntity, ItemStack itemstack, String model) {
        CustomBoxEntity packageEntity = (CustomBoxEntity)((EntityType)Boxes.CUSTOM_PACKAGE.get()).create(world);
        packageEntity.model = model;
        Vec3 position = originalEntity.position();
        packageEntity.setPos(position);
        packageEntity.setBox(itemstack);
        packageEntity.setDeltaMovement(originalEntity.getDeltaMovement().scale(1.5));
        if (world != null && !world.isClientSide && ChuteBlock.isChute((BlockState)world.getBlockState(BlockPos.containing((double)position.x, (double)(position.y + 0.5), (double)position.z)))) {
            packageEntity.setYRot((int)packageEntity.getYRot() / 90 * 90);
        }
        return packageEntity;
    }

    public boolean isOnConveyor() {
        return this.getVehicle() instanceof AbstractContraptionEntity;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("model", this.model);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.model = compound.getString("model");
    }
}

