/*
 * Decompiled with CFR 0.152.
 */
package com.Portality.ccomunityboxes.boxes.summonItems;

import com.Portality.ccomunityboxes.boxes.Boxes;
import com.Portality.ccomunityboxes.boxes.CustomBoxEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import java.lang.ref.WeakReference;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SummonBoxitem
extends PackageItem {
    public SummonBoxitem(Item.Properties properties, PackageStyles.PackageStyle style) {
        super(properties, style);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemstack) {
        return CustomBoxEntity.fromDroppedItem(world, location, itemstack, this.getModel());
    }

    public InteractionResultHolder<ItemStack> open(Level worldIn, Player playerIn, InteractionHand handIn) {
        return super.open(worldIn, playerIn, handIn);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int ticks) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int i = this.getUseDuration(stack, entity) - ticks;
        if (i < 0) {
            return;
        }
        float f = SummonBoxitem.getPackageVelocity((int)i);
        if ((double)f < 0.1) {
            return;
        }
        if (world.isClientSide) {
            return;
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.5f);
        ItemStack copy = stack.copy();
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        Vec3 vec = new Vec3(entity.getX(), entity.getY() + entity.getBoundingBox().getYsize() / 2.0, entity.getZ());
        Vec3 motion = entity.getLookAngle().scale((double)(f * 2.0f));
        vec = vec.add(motion);
        CustomBoxEntity packageEntity = new CustomBoxEntity((EntityType)Boxes.CUSTOM_PACKAGE.get(), world, vec.x, vec.y, vec.z, this.getModel());
        packageEntity.setBox(copy);
        packageEntity.setDeltaMovement(motion);
        packageEntity.tossedBy = new WeakReference<Player>(player);
        world.addFreshEntity((Entity)packageEntity);
    }

    public InteractionResult useOn(UseOnContext context) {
        Vec3 point = context.getClickLocation();
        float h = (float)this.style.height() / 16.0f;
        float r = (float)this.style.width() / 2.0f / 16.0f;
        if (context.getClickedFace() == Direction.DOWN) {
            point = point.subtract(0.0, (double)(h + 0.25f), 0.0);
        } else if (context.getClickedFace().getAxis().isHorizontal()) {
            point = point.add(Vec3.atLowerCornerOf((Vec3i)context.getClickedFace().getNormal()).scale((double)r));
        }
        AABB scanBB = new AABB(point, point).inflate((double)r, 0.0, (double)r).expandTowards(0.0, (double)h, 0.0);
        Level world = context.getLevel();
        if (!world.getEntities((EntityTypeTest)Boxes.CUSTOM_PACKAGE.get(), scanBB, e -> true).isEmpty()) {
            return super.useOn(context);
        }
        CustomBoxEntity packageEntity = new CustomBoxEntity((EntityType)Boxes.CUSTOM_PACKAGE.get(), world, point.x, point.y, point.z, this.getModel());
        ItemStack itemInHand = context.getItemInHand();
        packageEntity.setBox(itemInHand.copy());
        world.addFreshEntity((Entity)packageEntity);
        itemInHand.shrink(1);
        return InteractionResult.SUCCESS;
    }

    public String getModel() {
        String model = BuiltInRegistries.ITEM.getKey((Object)this).toString();
        String[] words = model.split(":");
        return words[1];
    }
}

