/*
 * Decompiled with CFR 0.152.
 */
package com.Portality.ccomunityboxes.mixins;

import com.Portality.ccomunityboxes.fluid.ModFluids;
import com.Portality.ccomunityboxes.painter.PainterBE;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpoutBlockEntity.class})
public abstract class MixinSpoutBe {
    @Shadow(remap=false)
    private int processingTicks;
    @Shadow
    private SmartFluidTankBehaviour tank;
    @Shadow
    @Final
    public static int FILLING_TIME;

    @Shadow
    protected abstract FluidStack getCurrentFluidInTank();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        BlockPos filling;
        BlockEntity blockEntity;
        SpoutBlockEntity be = (SpoutBlockEntity)this;
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        FluidStack currentFluidInTank = this.getCurrentFluidInTank();
        if (this.processingTicks == -1 && (be.isVirtual() || !level.isClientSide()) && (blockEntity = level.getBlockEntity(filling = pos.below())) instanceof PainterBE) {
            PainterBE painterBE = (PainterBE)blockEntity;
            if (currentFluidInTank.getFluid().getFluidType() == Fluids.WATER.getFluidType() && currentFluidInTank.getAmount() >= 500) {
                this.splash(pos, level, currentFluidInTank, (BlockEntity)be, painterBE, false);
            } else if (currentFluidInTank.getFluid().getFluidType() == ModFluids.INK.get() && currentFluidInTank.getAmount() >= 100) {
                this.splash(pos, level, currentFluidInTank, (BlockEntity)be, painterBE, true);
            }
        }
    }

    private void splash(BlockPos pos, Level level, FluidStack currentFluidInTank, BlockEntity be, PainterBE painterBE, boolean rareMode) {
        if (painterBE.craftProgress == 5) {
            if (rareMode) {
                painterBE.splashed = true;
                painterBE.rareSplashed = true;
                this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)currentFluidInTank, (int)(currentFluidInTank.getAmount() - 100)));
            } else {
                painterBE.splashed = true;
                this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)currentFluidInTank, (int)(currentFluidInTank.getAmount() - 500)));
            }
            this.processingTicks = FILLING_TIME;
            AllSoundEvents.SPOUTING.playOnServer(level, (Vec3i)pos);
            ((SpoutBlockEntity)be).notifyUpdate();
        }
    }
}

